/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.client.ClientCompute;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientClusterGroupImpl;
import org.apache.ignite.internal.client.thin.ClientFutureImpl;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.NotificationListener;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

class ClientComputeImpl
implements ClientCompute,
NotificationListener {
    private static final byte NO_FAILOVER_FLAG_MASK = 1;
    private static final byte NO_RESULT_CACHE_FLAG_MASK = 2;
    private final ReliableChannel ch;
    private final ClientBinaryMarshaller marsh;
    private final ClientUtils utils;
    private final ClientClusterGroupImpl dfltGrp;
    private final Map<ClientChannel, Map<Long, ClientComputeTask<Object>>> activeTasks = new ConcurrentHashMap<ClientChannel, Map<Long, ClientComputeTask<Object>>>();
    private final ReadWriteLock guard = new ReentrantReadWriteLock();

    ClientComputeImpl(ReliableChannel ch, ClientBinaryMarshaller marsh, ClientClusterGroupImpl dfltGrp) {
        this.ch = ch;
        this.marsh = marsh;
        this.dfltGrp = dfltGrp;
        this.utils = new ClientUtils(marsh);
        ch.addNotificationListener(this);
        ch.addChannelCloseListener(clientCh -> {
            this.guard.writeLock().lock();
            try {
                Map<Long, ClientComputeTask<Object>> chTasks = this.activeTasks.remove(clientCh);
                if (!F.isEmpty(chTasks)) {
                    for (ClientComputeTask<Object> task : chTasks.values()) {
                        ((ClientComputeTask)task).fut.onDone(new ClientException("Channel to server is closed"));
                    }
                }
            }
            finally {
                this.guard.writeLock().unlock();
            }
        });
    }

    @Override
    public ClientClusterGroup clusterGroup() {
        return this.dfltGrp;
    }

    @Override
    public <T, R> R execute(String taskName, @Nullable T arg) throws ClientException, InterruptedException {
        return this.execute0(taskName, arg, this.dfltGrp, (byte)0, 0L);
    }

    @Override
    public <T, R> Future<R> executeAsync(String taskName, @Nullable T arg) throws ClientException {
        return this.executeAsync0(taskName, arg, this.dfltGrp, (byte)0, 0L);
    }

    @Override
    public ClientCompute withTimeout(long timeout) {
        return timeout == 0L ? this : new ClientComputeModificator(this, this.dfltGrp, 0, timeout);
    }

    @Override
    public ClientCompute withNoFailover() {
        return new ClientComputeModificator(this, this.dfltGrp, 1, 0L);
    }

    @Override
    public ClientCompute withNoResultCache() {
        return new ClientComputeModificator(this, this.dfltGrp, 2, 0L);
    }

    public ClientCompute withClusterGroup(ClientClusterGroupImpl grp) {
        return new ClientComputeModificator(this, grp, 0, 0L);
    }

    private <T, R> R execute0(String taskName, @Nullable T arg, ClientClusterGroupImpl clusterGrp, byte flags, long timeout) throws ClientException {
        try {
            return this.executeAsync0(taskName, arg, clusterGrp, flags, timeout).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof ClientException) {
                throw (ClientException)e.getCause();
            }
            throw new ClientException(e);
        }
    }

    private <T, R> Future<R> executeAsync0(String taskName, @Nullable T arg, ClientClusterGroupImpl clusterGrp, byte flags, long timeout) throws ClientException {
        ClientComputeTask<Object> task;
        Collection<UUID> nodeIds = clusterGrp.nodeIds();
        if (F.isEmpty(taskName)) {
            throw new ClientException("Task name can't be null or empty.");
        }
        if (nodeIds != null && nodeIds.isEmpty()) {
            throw new ClientException("Cluster group is empty.");
        }
        do {
            T2 taskParams;
            Consumer<PayloadOutputChannel> payloadWriter = ch -> this.writeExecuteTaskRequest((PayloadOutputChannel)ch, taskName, arg, nodeIds, flags, timeout);
            Function<PayloadInputChannel, T2> payloadReader = ch -> new T2<ClientChannel, Long>(ch.clientChannel(), ch.in().readLong());
            try {
                taskParams = this.ch.service(ClientOperation.COMPUTE_TASK_EXECUTE, payloadWriter, payloadReader);
            }
            catch (ClientServerError error) {
                throw new ClientException(error.getMessage());
            }
            task = this.addTask((ClientChannel)taskParams.get1(), (Long)taskParams.get2());
        } while (task == null);
        ((ClientComputeTask)task).fut.listen(f -> {
            if (!f.isCancelled()) {
                this.removeTask(((ClientComputeTask)task).ch, ((ClientComputeTask)task).taskId);
            }
        });
        return new ClientFutureImpl(((ClientComputeTask)task).fut);
    }

    private <T> void writeExecuteTaskRequest(PayloadOutputChannel ch, String taskName, @Nullable T arg, Collection<UUID> nodeIds, byte flags, long timeout) throws ClientException {
        if (!ch.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.EXECUTE_TASK_BY_NAME)) {
            throw new ClientFeatureNotSupportedByServerException("Compute grid functionality for thin client not supported by server node (" + ch.clientChannel().serverNodeId() + ')');
        }
        try (BinaryRawWriterEx w = this.utils.createBinaryWriter(ch.out());){
            if (nodeIds == null) {
                w.writeInt(0);
            } else {
                w.writeInt(nodeIds.size());
                for (UUID nodeId : nodeIds) {
                    w.writeLong(nodeId.getMostSignificantBits());
                    w.writeLong(nodeId.getLeastSignificantBits());
                }
            }
            w.writeByte(flags);
            w.writeLong(timeout);
            w.writeString(taskName);
            w.writeObject(arg);
        }
    }

    @Override
    public void acceptNotification(ClientChannel ch, ClientOperation op, long rsrcId, byte[] payload, Exception err) {
        if (op == ClientOperation.COMPUTE_TASK_FINISHED) {
            Object res = payload == null ? null : (Object)this.utils.readObject(new BinaryHeapInputStream(payload), false);
            ClientComputeTask<Object> task = this.addTask(ch, rsrcId);
            if (task != null) {
                if (err == null) {
                    ((ClientComputeTask)task).fut.onDone(res);
                } else {
                    ((ClientComputeTask)task).fut.onDone(err);
                }
                if (((ClientComputeTask)task).fut.isCancelled()) {
                    this.removeTask(ch, rsrcId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientComputeTask<Object> addTask(ClientChannel ch, long taskId) {
        this.guard.readLock().lock();
        try {
            Map chTasks;
            boolean closed = ch.closed();
            Map map = chTasks = closed ? this.activeTasks.get(ch) : this.activeTasks.computeIfAbsent(ch, c -> new ConcurrentHashMap());
            if (chTasks == null) {
                ClientComputeTask<Object> clientComputeTask = null;
                return clientComputeTask;
            }
            ClientComputeTask clientComputeTask = closed ? (ClientComputeTask)chTasks.get(taskId) : chTasks.computeIfAbsent(taskId, t -> new ClientComputeTask(ch, taskId));
            return clientComputeTask;
        }
        finally {
            this.guard.readLock().unlock();
        }
    }

    private ClientComputeTask<Object> removeTask(ClientChannel ch, long taskId) {
        Map<Long, ClientComputeTask<Object>> chTasks = this.activeTasks.get(ch);
        if (!F.isEmpty(chTasks)) {
            return chTasks.remove(taskId);
        }
        return null;
    }

    Map<IgniteUuid, IgniteInternalFuture<?>> activeTaskFutures() {
        HashMap res = new HashMap();
        for (Map.Entry<ClientChannel, Map<Long, ClientComputeTask<Object>>> chTasks : this.activeTasks.entrySet()) {
            for (Map.Entry<Long, ClientComputeTask<Object>> task : chTasks.getValue().entrySet()) {
                res.put(new IgniteUuid(chTasks.getKey().serverNodeId(), task.getKey()), ((ClientComputeTask)task.getValue()).fut);
            }
        }
        return res;
    }

    private static class ClientComputeTask<R> {
        private final ClientChannel ch;
        private final long taskId;
        private final GridFutureAdapter<R> fut;

        private ClientComputeTask(final ClientChannel ch, final long taskId) {
            this.ch = ch;
            this.taskId = taskId;
            this.fut = new GridFutureAdapter<R>(){

                @Override
                public boolean cancel() {
                    if (this.onCancelled()) {
                        block3: {
                            try {
                                ch.service(ClientOperation.RESOURCE_CLOSE, req -> req.out().writeLong(taskId), null);
                            }
                            catch (ClientServerError e) {
                                if (e.getCode() == 1011) break block3;
                                throw new ClientException(e);
                            }
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class ClientComputeModificator
    implements ClientCompute {
        private final ClientComputeImpl delegate;
        private final ClientClusterGroupImpl clusterGrp;
        private final byte flags;
        private final long timeout;

        private ClientComputeModificator(ClientComputeImpl delegate, ClientClusterGroupImpl clusterGrp, byte flags, long timeout) {
            this.delegate = delegate;
            this.clusterGrp = clusterGrp;
            this.flags = flags;
            this.timeout = timeout;
        }

        @Override
        public ClientClusterGroup clusterGroup() {
            return this.clusterGrp;
        }

        @Override
        public <T, R> R execute(String taskName, @Nullable T arg) throws ClientException, InterruptedException {
            return (R)this.delegate.execute0(taskName, arg, this.clusterGrp, this.flags, this.timeout);
        }

        @Override
        public <T, R> Future<R> executeAsync(String taskName, @Nullable T arg) throws ClientException {
            return this.delegate.executeAsync0(taskName, arg, this.clusterGrp, this.flags, this.timeout);
        }

        @Override
        public ClientCompute withTimeout(long timeout) {
            return timeout == this.timeout ? this : new ClientComputeModificator(this.delegate, this.clusterGrp, this.flags, timeout);
        }

        @Override
        public ClientCompute withNoFailover() {
            return (this.flags & 1) != 0 ? this : new ClientComputeModificator(this.delegate, this.clusterGrp, (byte)(this.flags | 1), this.timeout);
        }

        @Override
        public ClientCompute withNoResultCache() {
            return (this.flags & 2) != 0 ? this : new ClientComputeModificator(this.delegate, this.clusterGrp, (byte)(this.flags | 2), this.timeout);
        }
    }
}

