/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.StreamMetadata;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.util.control.NonFatal$;

public final class StreamMetadata$
implements Logging,
Serializable {
    public static final StreamMetadata$ MODULE$;
    private final Formats format;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StreamMetadata$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Formats format() {
        return this.format;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<StreamMetadata> read(Path metadataFile, Configuration hadoopConf) {
        None$ none$;
        FileSystem fs = metadataFile.getFileSystem(hadoopConf);
        if (!fs.exists(metadataFile)) {
            none$ = None$.MODULE$;
            return none$;
        }
        FSDataInputStream input = null;
        try {
            input = fs.open(metadataFile);
            InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
            StreamMetadata metadata = (StreamMetadata)Serialization$.MODULE$.read((Reader)reader, this.format(), ManifestFactory$.MODULE$.classType(StreamMetadata.class));
            none$ = new Some((Object)metadata);
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)new Serializable(metadataFile){
                    public static final long serialVersionUID = 0L;
                    private final Path metadataFile$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading stream metadata from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metadataFile$1}));
                    }
                    {
                        this.metadataFile$1 = metadataFile$1;
                    }
                }, e);
                throw e;
            }
            catch (Throwable throwable3) {
                void var4_4;
                IOUtils.closeQuietly((InputStream)var4_4);
                throw throwable3;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return none$;
    }

    public void write(StreamMetadata metadata, Path metadataFile, Configuration hadoopConf) {
        CheckpointFileManager.CancellableFSDataOutputStream output2 = null;
        try {
            CheckpointFileManager fileManager = CheckpointFileManager$.MODULE$.create(metadataFile.getParent(), hadoopConf);
            output2 = fileManager.createAtomic(metadataFile, false);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)output2));
            Serialization$.MODULE$.write((Object)metadata, (Writer)writer, this.format());
            writer.close();
            return;
        }
        catch (Throwable throwable) {
            if (output2 != null) {
                output2.cancel();
            }
            this.logError((Function0<String>)new Serializable(metadata, metadataFile){
                public static final long serialVersionUID = 0L;
                private final StreamMetadata metadata$1;
                private final Path metadataFile$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing stream metadata ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metadata$1, this.metadataFile$2}));
                }
                {
                    this.metadata$1 = metadata$1;
                    this.metadataFile$2 = metadataFile$2;
                }
            }, throwable);
            throw throwable;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            if (output2 != null) {
                output2.cancel();
            }
            throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple streaming queries are concurrently using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadataFile})), fileAlreadyExistsException);
        }
    }

    public StreamMetadata apply(String id) {
        return new StreamMetadata(id);
    }

    public Option<String> unapply(StreamMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.id());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StreamMetadata$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.format = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

