/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.Model;
import org.jclouds.cloudsigma.domain.NIC;

@Singleton
public class MapToNICs
implements Function<Map<String, String>, List<NIC>> {
    public List<NIC> apply(Map<String, String> from) {
        ImmutableList.Builder nics = ImmutableList.builder();
        for (int id : new int[]{0, 1}) {
            String key = String.format("nic:%d", id);
            if (!from.containsKey(key + ":model")) break;
            NIC.Builder nicBuilder = new NIC.Builder();
            nicBuilder.dhcp(from.get(key + ":dhcp"));
            nicBuilder.model(Model.fromValue(from.get(key + ":model")));
            nicBuilder.vlan(from.get(key + ":vlan"));
            nicBuilder.mac(from.get(key + ":mac"));
            if (from.containsKey(key + ":block")) {
                nicBuilder.block(Splitter.on((char)' ').split((CharSequence)from.get(key + ":block")));
            }
            nics.add((Object)nicBuilder.build());
        }
        return nics.build();
    }
}

