/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.domain.ServerStatus;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

@Singleton
public class ServerInfoToNodeMetadata
implements Function<ServerInfo, NodeMetadata> {
    public static final Map<ServerStatus, NodeMetadata.Status> serverStatusToNodeStatus = ImmutableMap.builder().put((Object)ServerStatus.ACTIVE, (Object)NodeMetadata.Status.RUNNING).put((Object)ServerStatus.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)ServerStatus.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)ServerStatus.DUMPED, (Object)NodeMetadata.Status.PENDING).put((Object)ServerStatus.DEAD, (Object)NodeMetadata.Status.TERMINATED).put((Object)ServerStatus.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Function<Server, String> getImageIdFromServer;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Location> locationSupplier;
    private final Function<Device, Volume> deviceToVolume;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerInfoToNodeMetadata(Function<Server, String> getImageIdFromServer, @Memoized Supplier<Set<? extends Image>> images, Function<Device, Volume> deviceToVolume, Supplier<Location> locationSupplier, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locationSupplier = (Supplier)Preconditions.checkNotNull(locationSupplier, (Object)"locationSupplier");
        this.deviceToVolume = (Function)Preconditions.checkNotNull(deviceToVolume, (Object)"deviceToVolume");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.getImageIdFromServer = (Function)Preconditions.checkNotNull(getImageIdFromServer, (Object)"getImageIdFromServer");
    }

    public NodeMetadata apply(ServerInfo from) {
        Optional image;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getUuid());
        builder.name(from.getName());
        builder.location((Location)this.locationSupplier.get());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        String imageId = (String)this.getImageIdFromServer.apply((Object)from);
        if (imageId != null && (image = FluentIterable.from((Iterable)((Iterable)this.images.get())).firstMatch(ImagePredicates.idEquals((String)imageId))).isPresent()) {
            builder.operatingSystem(((Image)image.get()).getOperatingSystem());
        }
        builder.hardware(new HardwareBuilder().ids(from.getUuid()).hypervisor("kvm").processors((Iterable)ImmutableList.of((Object)new Processor(1.0, (double)from.getCpu()))).ram(from.getMem()).volumes(Iterables.transform(from.getDevices().values(), this.deviceToVolume)).build());
        builder.status(serverStatusToNodeStatus.get((Object)from.getStatus()));
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getVnc().getIp()));
        builder.privateAddresses((Iterable)ImmutableSet.of());
        return builder.build();
    }

    @Singleton
    public static class GetImageIdFromServer
    implements Function<Server, String> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public GetImageIdFromServer(LoadingCache<String, DriveInfo> cache) {
            this.cache = cache;
        }

        public String apply(Server from) {
            String imageId = null;
            String bootDeviceId = (String)Iterables.get(from.getBootDeviceIds(), (int)0);
            Device bootDevice = from.getDevices().get(bootDeviceId);
            if (bootDevice != null) {
                try {
                    DriveInfo drive = (DriveInfo)this.cache.getUnchecked((Object)bootDevice.getDriveUuid());
                    imageId = drive.getName();
                }
                catch (NullPointerException e) {
                    this.logger.debug("drive %s not found", new Object[]{bootDevice.getDriveUuid()});
                }
                catch (UncheckedExecutionException e) {
                    this.logger.warn((Throwable)e, "error finding drive %s: %s", new Object[]{bootDevice.getDriveUuid(), e.getMessage()});
                }
            }
            return imageId;
        }
    }

    @Singleton
    public static final class DeviceToVolume
    implements Function<Device, Volume> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public DeviceToVolume(LoadingCache<String, DriveInfo> cache) {
            this.cache = (LoadingCache)Preconditions.checkNotNull(cache, (Object)"cache");
        }

        public Volume apply(Device input) {
            VolumeBuilder builder = new VolumeBuilder();
            builder.id(input.getId());
            try {
                DriveInfo drive = (DriveInfo)this.cache.getUnchecked((Object)input.getDriveUuid());
                builder.size(Float.valueOf(drive.getSize()));
            }
            catch (NullPointerException e) {
                this.logger.debug("drive %s not found", new Object[]{input.getDriveUuid()});
            }
            catch (UncheckedExecutionException e) {
                this.logger.warn((Throwable)e, "error finding drive %s: %s", new Object[]{input.getDriveUuid(), e.getMessage()});
            }
            return builder.durable(true).type(Volume.Type.NAS).build();
        }
    }
}

