/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorBinaryTypeConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private String idMapper;
    private String nameMapper;
    private String serializer;
    private boolean isEnum;

    public static List<VisorBinaryTypeConfiguration> list(Collection<BinaryTypeConfiguration> cfgs) {
        ArrayList<VisorBinaryTypeConfiguration> res = new ArrayList<VisorBinaryTypeConfiguration>();
        if (!F.isEmpty(cfgs)) {
            for (BinaryTypeConfiguration cfg : cfgs) {
                res.add(new VisorBinaryTypeConfiguration(cfg));
            }
        }
        return res;
    }

    public VisorBinaryTypeConfiguration() {
    }

    public VisorBinaryTypeConfiguration(BinaryTypeConfiguration src) {
        this.typeName = src.getTypeName();
        this.idMapper = VisorTaskUtils.compactClass(src.getIdMapper());
        this.nameMapper = VisorTaskUtils.compactClass(src.getNameMapper());
        this.serializer = VisorTaskUtils.compactClass(src.getSerializer());
        this.isEnum = src.isEnum();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getIdMapper() {
        return this.idMapper;
    }

    public String getNameMapper() {
        return this.nameMapper;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.typeName);
        U.writeString(out, this.idMapper);
        U.writeString(out, this.nameMapper);
        U.writeString(out, this.serializer);
        out.writeBoolean(this.isEnum);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = U.readString(in);
        this.idMapper = U.readString(in);
        this.nameMapper = U.readString(in);
        this.serializer = U.readString(in);
        this.isEnum = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorBinaryTypeConfiguration.class, this);
    }
}

