/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.sandbox;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.transactions.Transaction;

public final class SandboxIgniteComponentProxy {
    private static final Class<?>[] PROXIED_CLASSES = new Class[]{Ignite.class, IgniteCache.class, IgniteCompute.class, ExecutorService.class, IgniteTransactions.class, IgniteDataStreamer.class, IgniteAtomicSequence.class, IgniteAtomicLong.class, IgniteAtomicReference.class, IgniteAtomicStamped.class, IgniteCountDownLatch.class, IgniteSemaphore.class, IgniteLock.class, IgniteQueue.class, IgniteSet.class, IgniteBinary.class, Affinity.class, QueryCursor.class, GridIterator.class, Transaction.class, BinaryObject.class};

    public static Ignite igniteProxy(Ignite ignite) {
        return SandboxIgniteComponentProxy.proxy(((IgniteEx)ignite).context(), Ignite.class, ignite);
    }

    private static <T> T proxy(GridKernalContext ctx, Class<?> cls, T instance) {
        Objects.requireNonNull(cls, "Parameter 'cls' cannot be null.");
        Objects.requireNonNull(instance, "Parameter 'instance' cannot be null.");
        return (T)SecurityUtils.doPrivileged(() -> Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)new SandboxIgniteComponentProxyHandler(ctx, instance)));
    }

    private static class SandboxIgniteComponentProxyHandler
    implements InvocationHandler {
        private final Object original;
        private final GridKernalContext ctx;

        public SandboxIgniteComponentProxyHandler(GridKernalContext ctx, Object original) {
            this.ctx = ctx;
            this.original = original;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            Object res = SecurityUtils.doPrivileged(() -> mtd.invoke(this.original, args));
            if (res != null && SecurityUtils.isSystemType(this.ctx, res, true)) {
                Class<?> cls = this.proxiedClass(res);
                return cls != null ? SandboxIgniteComponentProxy.proxy(this.ctx, cls, res) : res;
            }
            return res;
        }

        private Class<?> proxiedClass(Object obj) {
            for (Class cls : PROXIED_CLASSES) {
                if (!cls.isInstance(obj)) continue;
                return cls;
            }
            return null;
        }
    }
}

