/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.subcommands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.meta.MetadataSubCommandsList;
import org.apache.ignite.internal.commandline.meta.subcommands.MetadataAbstractSubCommand;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataMarshalled;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataUpdateTask;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MetadataUpdateCommand
extends MetadataAbstractSubCommand<MetadataMarshalled, MetadataMarshalled> {
    public static final String IN_FILE_NAME = "--in";

    @Override
    protected String taskName() {
        return MetadataUpdateTask.class.getName();
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will update the binary metadata at the cluster.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MetadataMarshalled parseArguments0(CommandArgIterator argIter) {
        String opt = argIter.nextArg(IN_FILE_NAME);
        if (!IN_FILE_NAME.equalsIgnoreCase(opt)) {
            throw new IllegalArgumentException("The option '--in' is required");
        }
        Path inFile = FS.getPath(argIter.nextArg("input file name"), new String[0]);
        try (InputStream is = Files.newInputStream(inFile, new OpenOption[0]);){
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            U.copy(is, buf);
            MetadataMarshalled metadataMarshalled = new MetadataMarshalled(buf.toByteArray(), null);
            return metadataMarshalled;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read metadata from " + inFile, e);
        }
    }

    @Override
    protected void printResult(MetadataMarshalled res, Logger log) {
        if (res.metadata() == null) {
            log.info("Type not found");
            return;
        }
        BinaryMetadata m = res.metadata();
        log.info("Metadata updated for the type: '" + m.typeName() + '\'');
    }

    @Override
    public String name() {
        return MetadataSubCommandsList.UPDATE.text();
    }
}

