/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryFieldEx;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySchemaRegistry;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.streams.BinaryByteBufferInputStream;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryFieldImpl
implements BinaryFieldEx {
    private final BinaryContext ctx;
    private final int typeId;
    @GridToStringExclude
    private final BinarySchemaRegistry schemas;
    private final String fieldName;
    private final int fieldId;

    public BinaryFieldImpl(BinaryContext ctx, int typeId, BinarySchemaRegistry schemas, String fieldName, int fieldId) {
        assert (ctx != null);
        assert (typeId != 0);
        assert (schemas != null);
        assert (fieldId != 0);
        this.ctx = ctx;
        this.typeId = typeId;
        this.schemas = schemas;
        this.fieldName = fieldName;
        this.fieldId = fieldId;
    }

    @Override
    public String name() {
        return this.fieldName;
    }

    public int fieldId() {
        return this.fieldId;
    }

    @Override
    public boolean exists(BinaryObject obj) {
        BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
        return this.fieldOrder(obj0) != -1;
    }

    @Override
    public <T> T value(BinaryObject obj) {
        BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
        int order = this.fieldOrder(obj0);
        return order != -1 ? (T)obj0.fieldByOrder(order) : null;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public boolean writeField(BinaryObject obj, ByteBuffer buf) {
        BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
        int order = this.fieldOrder(obj0);
        return obj0.writeFieldByOrder(order, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <F> F readField(ByteBuffer buf) {
        ByteOrder oldOrder = buf.order();
        try {
            Object val;
            buf.order(ByteOrder.LITTLE_ENDIAN);
            int pos = buf.position();
            byte hdr = buf.get();
            switch (hdr) {
                case 3: {
                    val = buf.getInt();
                    break;
                }
                case 4: {
                    val = buf.getLong();
                    break;
                }
                case 8: {
                    val = buf.get() != 0;
                    break;
                }
                case 2: {
                    val = buf.getShort();
                    break;
                }
                case 1: {
                    val = buf.get();
                    break;
                }
                case 7: {
                    val = Character.valueOf(buf.getChar());
                    break;
                }
                case 5: {
                    val = Float.valueOf(buf.getFloat());
                    break;
                }
                case 6: {
                    val = buf.getDouble();
                    break;
                }
                case 9: {
                    int dataLen = buf.getInt();
                    byte[] data = new byte[dataLen];
                    buf.get(data);
                    val = new String(data, 0, dataLen, StandardCharsets.UTF_8);
                    break;
                }
                case 11: {
                    long time = buf.getLong();
                    val = new Date(time);
                    break;
                }
                case 33: {
                    long time = buf.getLong();
                    int nanos = buf.getInt();
                    Timestamp ts = new Timestamp(time);
                    ts.setNanos(ts.getNanos() + nanos);
                    val = ts;
                    break;
                }
                case 36: {
                    long time = buf.getLong();
                    val = new Time(time);
                    break;
                }
                case 10: {
                    long most = buf.getLong();
                    long least = buf.getLong();
                    val = new UUID(most, least);
                    break;
                }
                case 30: {
                    boolean negative;
                    int scale = buf.getInt();
                    int dataLen = buf.getInt();
                    byte[] data = new byte[dataLen];
                    buf.get(data);
                    boolean bl = negative = data[0] < 0;
                    if (negative) {
                        data[0] = (byte)(data[0] & 0x7F);
                    }
                    BigInteger intVal = new BigInteger(data);
                    if (negative) {
                        intVal = intVal.negate();
                    }
                    val = new BigDecimal(intVal, scale);
                    break;
                }
                case 101: {
                    val = null;
                    break;
                }
                default: {
                    buf.position(pos);
                    val = BinaryUtils.unmarshal(BinaryByteBufferInputStream.create(buf), this.ctx, null);
                }
            }
            Constable constable = val;
            return (F)constable;
        }
        finally {
            buf.order(oldOrder);
        }
    }

    public int fieldOrder(BinaryObjectExImpl obj) {
        if (this.typeId != obj.typeId()) {
            BinaryType expType = this.ctx.metadata(this.typeId);
            BinaryType actualType = obj.type();
            String actualTypeName = null;
            BinaryObjectException actualTypeNameEx = null;
            try {
                actualTypeName = actualType.typeName();
            }
            catch (BinaryObjectException e) {
                actualTypeNameEx = new BinaryObjectException("Failed to get actual binary type name.", e);
            }
            throw new BinaryObjectException("Failed to get field because type ID of passed object differs from type ID this " + BinaryField.class.getSimpleName() + " belongs to [expected=[typeId=" + this.typeId + ", typeName=" + (Objects.nonNull(expType) ? expType.typeName() : null) + "], actual=[typeId=" + actualType.typeId() + ", typeName=" + actualTypeName + "], fieldId=" + this.fieldId + ", fieldName=" + this.fieldName + ", fieldType=" + (Objects.nonNull(expType) ? expType.fieldTypeName(this.fieldName) : null) + ']', actualTypeNameEx);
        }
        int schemaId = obj.schemaId();
        if (schemaId == 0) {
            return -1;
        }
        BinarySchema schema = this.schemas.schema(schemaId);
        if (schema == null) {
            schema = obj.createSchema();
            this.schemas.addSchema(schemaId, schema);
        }
        assert (schema != null);
        return schema.order(this.fieldId);
    }

    public String toString() {
        return S.toString(BinaryFieldImpl.class, this);
    }
}

