/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class BusyPoolException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public BusyPoolException(InetSocketAddress address, int queueSize) {
        this(address, BusyPoolException.buildMessage(address, queueSize), null);
    }

    public BusyPoolException(InetSocketAddress address, long timeout, TimeUnit unit) {
        this(address, BusyPoolException.buildMessage(address, timeout, unit), null);
    }

    private BusyPoolException(InetSocketAddress address, String message, Throwable cause) {
        super(message, cause);
        this.address = address;
    }

    private static String buildMessage(InetSocketAddress address, int queueSize) {
        return String.format("[%s] Pool is busy (no available connection and the queue has reached its max size %d)", address.getAddress(), queueSize);
    }

    private static String buildMessage(InetSocketAddress address, long timeout, TimeUnit unit) {
        return String.format("[%s] Pool is busy (no available connection and timed out after %d %s)", new Object[]{address.getAddress(), timeout, unit});
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public BusyPoolException copy() {
        return new BusyPoolException(this.address, this.getMessage(), this);
    }
}

