/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.springdata20.repository.IgniteRepository;
import org.apache.ignite.springdata20.repository.support.ConditionFalse;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ConditionFalse.class})
public class IgniteRepositoryImpl<V, K extends Serializable>
implements IgniteRepository<V, K> {
    private final IgniteCache<K, V> cache;
    private final Ignite ignite;

    public IgniteRepositoryImpl(Ignite ignite, IgniteCache<K, V> cache) {
        this.cache = cache;
        this.ignite = ignite;
    }

    @Override
    public IgniteCache<K, V> cache() {
        return this.cache;
    }

    @Override
    public Ignite ignite() {
        return this.ignite;
    }

    @Override
    public <S extends V> S save(K key, S entity) {
        this.cache.put(key, entity);
        return entity;
    }

    @Override
    public <S extends V> Iterable<S> save(Map<K, S> entities) {
        this.cache.putAll(entities);
        return entities.values();
    }

    @Override
    public <S extends V> S save(K key, S entity, @Nullable ExpiryPolicy expiryPlc) {
        if (expiryPlc != null) {
            this.cache.withExpiryPolicy(expiryPlc).put(key, entity);
        } else {
            this.cache.put(key, entity);
        }
        return entity;
    }

    @Override
    public <S extends V> Iterable<S> save(Map<K, S> entities, @Nullable ExpiryPolicy expiryPlc) {
        if (expiryPlc != null) {
            this.cache.withExpiryPolicy(expiryPlc).putAll(entities);
        } else {
            this.cache.putAll(entities);
        }
        return entities.values();
    }

    public <S extends V> S save(S entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(key,value) method instead.");
    }

    public <S extends V> Iterable<S> saveAll(Iterable<S> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(Map<keys,value>) method instead.");
    }

    public Optional<V> findById(K id) {
        return Optional.ofNullable(this.cache.get(id));
    }

    public boolean existsById(K id) {
        return this.cache.containsKey(id);
    }

    public Iterable<V> findAll() {
        final Iterator iter = this.cache.iterator();
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Cache.Entry)iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    public Iterable<V> findAllById(Iterable<K> ids) {
        if (ids instanceof Set) {
            return this.cache.getAll((Set)ids).values();
        }
        if (ids instanceof Collection) {
            return this.cache.getAll(new HashSet((Collection)ids)).values();
        }
        TreeSet<Serializable> keys = new TreeSet<Serializable>();
        for (Serializable id : ids) {
            keys.add(id);
        }
        return this.cache.getAll(keys).values();
    }

    public long count() {
        return this.cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY});
    }

    public void deleteById(K id) {
        this.cache.remove(id);
    }

    public void delete(V entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.deleteById(key) method instead.");
    }

    public void deleteAll(Iterable<? extends V> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.deleteAllById(keys) method instead.");
    }

    @Override
    public void deleteAllById(Iterable<K> ids) {
        if (ids instanceof Set) {
            this.cache.removeAll((Set)ids);
            return;
        }
        if (ids instanceof Collection) {
            this.cache.removeAll(new HashSet((Collection)ids));
            return;
        }
        TreeSet<Serializable> keys = new TreeSet<Serializable>();
        for (Serializable id : ids) {
            keys.add(id);
        }
        this.cache.removeAll(keys);
    }

    public void deleteAll() {
        this.cache.clear();
    }
}

