/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.query.spel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.ignite.springdata20.repository.query.spel.SpelEvaluator;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class SpelQueryContext {
    private static final String SPEL_PATTERN_STRING = "([:?])#\\{([^}]+)}";
    private static final Pattern SPEL_PATTERN = Pattern.compile("([:?])#\\{([^}]+)}");
    private final BiFunction<Integer, String, String> paramNameSrc;
    private final BiFunction<String, String, String> replacementSrc;

    private SpelQueryContext(BiFunction<Integer, String, String> paramNameSrc, BiFunction<String, String, String> replacementSrc) {
        this.paramNameSrc = paramNameSrc;
        this.replacementSrc = replacementSrc;
    }

    public static SpelQueryContext of(BiFunction<Integer, String, String> parameterNameSource, BiFunction<String, String, String> replacementSource) {
        return new SpelQueryContext(parameterNameSource, replacementSource);
    }

    public SpelExtractor parse(String qry) {
        return new SpelExtractor(qry);
    }

    public EvaluatingSpelQueryContext withEvaluationContextProvider(EvaluationContextProvider provider) {
        Assert.notNull((Object)provider, (String)"EvaluationContextProvider must not be null!");
        return new EvaluatingSpelQueryContext(provider, this.paramNameSrc, this.replacementSrc);
    }

    static class QuotationMap {
        private static final Collection<Character> QUOTING_CHARACTERS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('\''));
        private final List<Range<Integer>> quotedRanges = new ArrayList<Range<Integer>>();

        public QuotationMap(@Nullable String qry) {
            if (qry == null) {
                return;
            }
            Character inQuotation = null;
            int start = 0;
            for (int i = 0; i < qry.length(); ++i) {
                char curChar = qry.charAt(i);
                if (!QUOTING_CHARACTERS.contains(Character.valueOf(curChar))) continue;
                if (inQuotation == null) {
                    inQuotation = Character.valueOf(curChar);
                    start = i;
                    continue;
                }
                if (curChar != inQuotation.charValue()) continue;
                inQuotation = null;
                this.quotedRanges.add((Range<Integer>)Range.from((Range.Bound)Range.Bound.inclusive((int)start)).to(Range.Bound.inclusive((int)i)));
            }
            if (inQuotation != null) {
                throw new IllegalArgumentException(String.format("The string <%s> starts a quoted range at %d, but never ends it.", qry, start));
            }
        }

        public boolean isQuoted(int idx) {
            return this.quotedRanges.stream().anyMatch(r -> r.contains((Comparable)Integer.valueOf(idx)));
        }
    }

    public class SpelExtractor {
        private static final int PREFIX_GROUP_INDEX = 1;
        private static final int EXPRESSION_GROUP_INDEX = 2;
        private final String query;
        private final Map<String, String> expressions;
        private final QuotationMap quotations;

        SpelExtractor(String qry) {
            Assert.notNull((Object)qry, (String)"Query must not be null");
            HashMap<String, String> exps = new HashMap<String, String>();
            Matcher matcher = SPEL_PATTERN.matcher(qry);
            StringBuilder resultQry = new StringBuilder();
            QuotationMap quotedAreas = new QuotationMap(qry);
            int expressionCounter = 0;
            int matchedUntil = 0;
            while (matcher.find()) {
                if (quotedAreas.isQuoted(matcher.start())) {
                    resultQry.append(qry, matchedUntil, matcher.end());
                } else {
                    String spelExpression = matcher.group(2);
                    String prefix = matcher.group(1);
                    String paramName = (String)SpelQueryContext.this.paramNameSrc.apply(expressionCounter, spelExpression);
                    String replacement = (String)SpelQueryContext.this.replacementSrc.apply(prefix, paramName);
                    resultQry.append(qry, matchedUntil, matcher.start());
                    resultQry.append(replacement);
                    exps.put(paramName, spelExpression);
                    ++expressionCounter;
                }
                matchedUntil = matcher.end();
            }
            resultQry.append(qry.substring(matchedUntil));
            this.expressions = Collections.unmodifiableMap(exps);
            this.query = resultQry.toString();
            this.quotations = quotedAreas;
        }

        public String getQueryString() {
            return this.query;
        }

        public boolean isQuoted(int idx) {
            return this.quotations.isQuoted(idx);
        }

        public String getParameter(String name) {
            return this.expressions.get(name);
        }

        Map<String, String> getParameterMap() {
            return this.expressions;
        }

        Stream<Map.Entry<String, String>> getParameters() {
            return this.expressions.entrySet().stream();
        }
    }

    public static class EvaluatingSpelQueryContext
    extends SpelQueryContext {
        private final EvaluationContextProvider evaluationContextProvider;

        private EvaluatingSpelQueryContext(EvaluationContextProvider evaluationCtxProvider, BiFunction<Integer, String, String> paramNameSrc, BiFunction<String, String, String> replacementSrc) {
            super(paramNameSrc, replacementSrc);
            this.evaluationContextProvider = evaluationCtxProvider;
        }

        public SpelEvaluator parse(String qry, Parameters<?, ?> parameters) {
            return new SpelEvaluator(this.evaluationContextProvider, parameters, this.parse(qry));
        }
    }
}

