/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.query.spel;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.springdata20.repository.query.spel.SpelQueryContext;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpelEvaluator {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final EvaluationContextProvider evaluationCtxProvider;
    private final Parameters<?, ?> parameters;
    private final SpelQueryContext.SpelExtractor extractor;

    public SpelEvaluator(EvaluationContextProvider evaluationCtxProvider, Parameters<?, ?> parameters, SpelQueryContext.SpelExtractor extractor) {
        this.evaluationCtxProvider = evaluationCtxProvider;
        this.parameters = parameters;
        this.extractor = extractor;
    }

    public Map<String, Object> evaluate(Object[] values) {
        Assert.notNull((Object)values, (String)"Values must not be null.");
        EvaluationContext evaluationCtx = this.evaluationCtxProvider.getEvaluationContext(this.parameters, values);
        return this.extractor.getParameters().collect(Collectors.toMap(Map.Entry::getKey, it -> SpelEvaluator.getSpElValue(evaluationCtx, (String)it.getValue())));
    }

    public String getQueryString() {
        return this.extractor.getQueryString();
    }

    @Nullable
    private static Object getSpElValue(EvaluationContext evaluationCtx, String expression) {
        return PARSER.parseExpression(expression).getValue(evaluationCtx);
    }
}

