/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.query;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.cache.Cache;
import org.apache.commons.lang.ArrayUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.binary.IgniteBinaryImpl;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.springdata20.repository.config.DynamicQueryConfig;
import org.apache.ignite.springdata20.repository.query.ExpressionBasedStringQuery;
import org.apache.ignite.springdata20.repository.query.IgniteQuery;
import org.apache.ignite.springdata20.repository.query.IgniteQueryGenerator;
import org.apache.ignite.springdata20.repository.query.StringQuery;
import org.apache.ignite.springdata20.repository.support.IgniteRepositoryFactory;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class IgniteRepositoryQuery
implements RepositoryQuery {
    private static final TreeMap<String, Class<?>> binaryFieldClass = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Class<?> type;
    private final IgniteQuery staticQuery;
    private final IgniteCache cache;
    private final Ignite ignite;
    private IgniteBinaryImpl igniteBinary;
    private BinaryType igniteBinType;
    private final Method mtd;
    private final RepositoryMetadata metadata;
    private final ProjectionFactory factory;
    private final ReturnStrategy staticReturnStgy;
    private final boolean hasProjection;
    private final boolean hasDynamicProjection;
    private final int dynamicProjectionIndex;
    private final int dynamicQueryConfigurationIndex;
    private final QueryMethod qMethod;
    private final Class<?> returnedDomainClass;
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider queryMethodEvaluationContextProvider;
    private final DynamicQueryConfig staticQueryConfiguration;

    public IgniteRepositoryQuery(Ignite ignite, RepositoryMetadata metadata, @Nullable IgniteQuery staticQuery, Method mtd, ProjectionFactory factory, IgniteCache cache, @Nullable DynamicQueryConfig staticQueryConfiguration, EvaluationContextProvider queryMethodEvaluationContextProvider) {
        this.metadata = metadata;
        this.mtd = mtd;
        this.factory = factory;
        this.type = metadata.getDomainType();
        this.cache = cache;
        this.ignite = ignite;
        this.staticQueryConfiguration = staticQueryConfiguration;
        this.staticQuery = staticQuery;
        this.staticReturnStgy = this.staticQuery != null ? this.calcReturnType(mtd, this.staticQuery.isFieldQuery()) : null;
        this.expressionParser = new SpelExpressionParser();
        this.queryMethodEvaluationContextProvider = queryMethodEvaluationContextProvider;
        this.qMethod = this.getQueryMethod();
        this.hasDynamicProjection = this.getQueryMethod().getParameters().hasDynamicProjection();
        this.hasProjection = this.hasDynamicProjection || this.getQueryMethod().getResultProcessor().getReturnedType().isProjecting();
        this.dynamicProjectionIndex = this.qMethod.getParameters().getDynamicProjectionIndex();
        this.returnedDomainClass = this.getQueryMethod().getReturnedObjectType();
        this.dynamicQueryConfigurationIndex = this.getDynamicQueryConfigurationIndex(this.qMethod);
        if (this.dynamicQueryConfigurationIndex == -1 && this.staticQuery == null) {
            throw new IllegalStateException("When passing dynamicQuery = true via org.apache.ignite.springdata.repository.config.Query annotation, you must provide a non null method parameter of type DynamicQueryConfig");
        }
        IgniteRepositoryQuery.registerClassOnMarshaller(((IgniteEx)ignite).context(), this.type);
    }

    public Object execute(Object[] values) {
        Object[] parameters = values;
        DynamicQueryConfig config = this.staticQueryConfiguration;
        if (config == null || this.dynamicQueryConfigurationIndex != -1) {
            DynamicQueryConfig newConfig = (DynamicQueryConfig)values[this.dynamicQueryConfigurationIndex];
            parameters = ArrayUtils.removeElement((Object[])parameters, (Object)this.dynamicQueryConfigurationIndex);
            if (newConfig != null) {
                config = newConfig;
            }
        }
        if (config == null) {
            throw new IllegalStateException("Unable to execute query. When passing dynamicQuery = true via org.apache.ignite.springdata.repository.config.Query annotation, you must provide a non null method parameter of type DynamicQueryConfig");
        }
        IgniteQuery qry = this.getQuery(config);
        ReturnStrategy returnStgy = this.getReturnStgy(qry);
        Query iQry = this.prepareQuery(qry, config, returnStgy, parameters);
        QueryCursor qryCursor = this.cache.query(iQry);
        return this.transformQueryCursor(qry, returnStgy, parameters, qryCursor);
    }

    public QueryMethod getQueryMethod() {
        return new QueryMethod(this.mtd, this.metadata, this.factory);
    }

    private <T extends Parameter> int getDynamicQueryConfigurationIndex(QueryMethod method) {
        Iterator it = method.getParameters().iterator();
        int i = 0;
        boolean found = false;
        int index = -1;
        while (it.hasNext()) {
            Parameter parameter = (Parameter)it.next();
            if (DynamicQueryConfig.class.isAssignableFrom(parameter.getType())) {
                if (found) {
                    throw new IllegalStateException("Invalid '" + method.getName() + "' repository method signature. Only ONE DynamicQueryConfig parameter is allowed");
                }
                found = true;
                index = i;
            }
            ++i;
        }
        return index;
    }

    private synchronized IgniteBinaryImpl binary() {
        if (this.igniteBinary == null) {
            this.igniteBinary = (IgniteBinaryImpl)this.ignite.binary();
        }
        return this.igniteBinary;
    }

    private synchronized BinaryType binType() {
        if (this.igniteBinType == null) {
            this.igniteBinType = this.binary().type(this.type);
        }
        return this.igniteBinType;
    }

    private ReturnStrategy calcReturnType(Method mtd, boolean isFieldQry) {
        Class<?> returnType = mtd.getReturnType();
        if (returnType == Slice.class) {
            if (isFieldQry) {
                if (this.hasAssignableGenericReturnTypeFrom(ArrayList.class, mtd)) {
                    return ReturnStrategy.SLICE_OF_LISTS;
                }
            } else if (this.hasAssignableGenericReturnTypeFrom(Cache.Entry.class, mtd)) {
                return ReturnStrategy.SLICE_OF_CACHE_ENTRIES;
            }
            return ReturnStrategy.SLICE_OF_VALUES;
        }
        if (returnType == Page.class) {
            return ReturnStrategy.PAGE_OF_VALUES;
        }
        if (returnType == Stream.class) {
            return ReturnStrategy.STREAM_OF_VALUES;
        }
        if (Cache.Entry.class.isAssignableFrom(returnType)) {
            return ReturnStrategy.CACHE_ENTRY;
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            if (isFieldQry) {
                if (this.hasAssignableGenericReturnTypeFrom(ArrayList.class, mtd)) {
                    return ReturnStrategy.LIST_OF_LISTS;
                }
            } else if (this.hasAssignableGenericReturnTypeFrom(Cache.Entry.class, mtd)) {
                return ReturnStrategy.LIST_OF_CACHE_ENTRIES;
            }
            return ReturnStrategy.LIST_OF_VALUES;
        }
        return ReturnStrategy.ONE_VALUE;
    }

    private boolean hasAssignableGenericReturnTypeFrom(Class<?> cls, Method mtd) {
        Type genericReturnType = mtd.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return false;
        }
        Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return false;
        }
        if (actualTypeArguments[0] instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)actualTypeArguments[0];
            Class type1 = (Class)type.getRawType();
            return type1.isAssignableFrom(cls);
        }
        if (actualTypeArguments[0] instanceof Class) {
            Class typeArg = (Class)actualTypeArguments[0];
            return typeArg.isAssignableFrom(cls);
        }
        return false;
    }

    private static <T> T fixExpectedType(Object object, Class<T> expected) {
        if (expected != null && object instanceof Timestamp && expected.equals(Date.class)) {
            return (T)new Date(((Timestamp)object).getTime());
        }
        return (T)object;
    }

    private IgniteQuery getQuery(@Nullable DynamicQueryConfig cfg) {
        if (this.staticQuery != null) {
            return this.staticQuery;
        }
        if (cfg != null && (StringUtils.hasText((String)cfg.value()) || cfg.textQuery())) {
            return new IgniteQuery(cfg.value(), !cfg.textQuery() && (IgniteRepositoryFactory.isFieldQuery(cfg.value()) || cfg.forceFieldsQuery()), cfg.textQuery(), false, IgniteQueryGenerator.getOptions(this.mtd));
        }
        throw new IllegalStateException("Unable to obtain a valid query. When passing dynamicQuery = true via org.apache.ignite.springdata.repository.config.Query annotation, you must provide a non null method parameter of type DynamicQueryConfig with a non empty value (query string) or textQuery = true");
    }

    private ReturnStrategy getReturnStgy(IgniteQuery qry) {
        if (this.staticReturnStgy != null) {
            return this.staticReturnStgy;
        }
        if (qry != null) {
            return this.calcReturnType(this.mtd, qry.isFieldQuery());
        }
        throw new IllegalStateException("Unable to obtain a valid return strategy. When passing dynamicQuery = true via org.apache.ignite.springdata.repository.config.Query annotation, you must provide a non null method parameter of type DynamicQueryConfig with a non empty value (query string) or textQuery = true");
    }

    private static boolean isPrimitiveOrWrapper(Class<?> cls) {
        return cls.isPrimitive() || Boolean.class.equals(cls) || Byte.class.equals(cls) || Character.class.equals(cls) || Short.class.equals(cls) || Integer.class.equals(cls) || Long.class.equals(cls) || Float.class.equals(cls) || Double.class.equals(cls) || Void.class.equals(cls) || String.class.equals(cls) || UUID.class.equals(cls);
    }

    @Nullable
    private Object transformQueryCursor(IgniteQuery qry, ReturnStrategy returnStgy, Object[] prmtrs, QueryCursor qryCursor) {
        Class<Object> returnClass = this.hasProjection ? (this.hasDynamicProjection ? (Class<Object>)prmtrs[this.dynamicProjectionIndex] : this.returnedDomainClass) : this.returnedDomainClass;
        if (qry.isFieldQuery()) {
            boolean singlePrimitiveResult = IgniteRepositoryQuery.isPrimitiveOrWrapper(returnClass);
            List meta = ((QueryCursorEx)qryCursor).fieldsMeta();
            Function<List, Object> cWrapperTransformFunction = null;
            if (this.type.equals(returnClass)) {
                IgniteBinaryImpl binary = this.binary();
                BinaryType binType = this.binType();
                cWrapperTransformFunction = row -> this.rowToEntity(binary, binType, (List<?>)row, meta);
            } else {
                cWrapperTransformFunction = this.hasProjection || singlePrimitiveResult ? (singlePrimitiveResult ? row -> row.get(0) : row -> this.factory.createProjection(returnClass, IgniteRepositoryQuery.rowToMap(row, meta))) : row -> IgniteRepositoryQuery.rowToMap(row, meta);
            }
            QueryCursorWrapper<List, Object> cWrapper = new QueryCursorWrapper<List, Object>(qryCursor, cWrapperTransformFunction);
            switch (returnStgy) {
                case PAGE_OF_VALUES: {
                    return new PageImpl(cWrapper.getAll(), (Pageable)prmtrs[prmtrs.length - 1], 0L);
                }
                case LIST_OF_VALUES: {
                    return cWrapper.getAll();
                }
                case STREAM_OF_VALUES: {
                    return cWrapper.stream();
                }
                case ONE_VALUE: {
                    Iterator<Object> iter = cWrapper.iterator();
                    if (iter.hasNext()) {
                        Object resp = iter.next();
                        U.closeQuiet(cWrapper);
                        return resp;
                    }
                    return null;
                }
                case SLICE_OF_VALUES: {
                    return new SliceImpl(cWrapper.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
                }
                case SLICE_OF_LISTS: {
                    return new SliceImpl(qryCursor.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
                }
                case LIST_OF_LISTS: {
                    return qryCursor.getAll();
                }
            }
            throw new IllegalStateException();
        }
        QueryCursor qryIter = qryCursor;
        Function<CacheEntryImpl, Object> cWrapperTransformFunction = this.hasProjection && !this.type.equals(returnClass) ? row -> this.factory.createProjection(returnClass, row.getValue()) : row -> row.getValue();
        QueryCursorWrapper<CacheEntryImpl, Object> cWrapper = new QueryCursorWrapper<CacheEntryImpl, Object>(qryCursor, cWrapperTransformFunction);
        switch (returnStgy) {
            case PAGE_OF_VALUES: {
                return new PageImpl(cWrapper.getAll(), (Pageable)prmtrs[prmtrs.length - 1], 0L);
            }
            case LIST_OF_VALUES: {
                return cWrapper.getAll();
            }
            case STREAM_OF_VALUES: {
                return cWrapper.stream();
            }
            case ONE_VALUE: {
                Iterator<Object> iter1 = cWrapper.iterator();
                if (iter1.hasNext()) {
                    Object resp = iter1.next();
                    U.closeQuiet(cWrapper);
                    return resp;
                }
                return null;
            }
            case CACHE_ENTRY: {
                Iterator iter2 = qryIter.iterator();
                if (iter2.hasNext()) {
                    Object resp2 = iter2.next();
                    U.closeQuiet((AutoCloseable)qryCursor);
                    return resp2;
                }
                return null;
            }
            case SLICE_OF_VALUES: {
                return new SliceImpl(cWrapper.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
            }
            case SLICE_OF_CACHE_ENTRIES: {
                return new SliceImpl(qryCursor.getAll(), (Pageable)prmtrs[prmtrs.length - 1], true);
            }
            case LIST_OF_CACHE_ENTRIES: {
                return qryCursor.getAll();
            }
        }
        throw new IllegalStateException();
    }

    private Object[] extractBindableValues(Object[] values, Parameters<?, ?> queryMethodParams, List<StringQuery.ParameterBinding> queryBindings) {
        if (queryBindings.isEmpty()) {
            return values;
        }
        Object[] newValues = new Object[queryBindings.size()];
        HashMap methodParams = new HashMap();
        EvaluationContext queryEvalContext = this.queryMethodEvaluationContextProvider.getEvaluationContext(queryMethodParams, values);
        queryMethodParams.getBindableParameters().forEach(p -> {
            if (p.isNamedParameter()) {
                methodParams.put(p.getName().get(), p.getIndex());
            }
            methodParams.put(String.valueOf(p.getIndex()), p.getIndex());
        });
        for (int i = 0; i < queryBindings.size(); ++i) {
            StringQuery.ParameterBinding p2 = queryBindings.get(i);
            newValues[i] = p2.isExpression() ? this.expressionParser.parseExpression(p2.getExpression()).getValue(queryEvalContext) : values[(Integer)methodParams.get(p2.getName() != null ? p2.getName() : String.valueOf(p2.getRequiredPosition() - 1))];
        }
        return newValues;
    }

    private Query prepareQuery(IgniteQuery qry, DynamicQueryConfig config, ReturnStrategy returnStgy, Object[] values) {
        TextQuery query;
        Object[] parameters = values;
        String queryString = qry.qryStr();
        this.checkRequiredPageable(returnStgy, values);
        if (!qry.isTextQuery()) {
            if (!qry.isAutogenerated()) {
                ExpressionBasedStringQuery squery = new ExpressionBasedStringQuery(queryString, this.metadata, this.expressionParser);
                queryString = squery.getQueryString();
                parameters = this.extractBindableValues(parameters, this.getQueryMethod().getParameters(), squery.getParameterBindings());
            } else if (this.hasDynamicProjection) {
                parameters = ArrayUtils.remove((Object[])parameters, (int)this.dynamicProjectionIndex);
            }
            switch (qry.options()) {
                case SORTING: {
                    queryString = IgniteQueryGenerator.addSorting(new StringBuilder(queryString), (Sort)values[values.length - 1]).toString();
                    if (!qry.isAutogenerated()) break;
                    parameters = Arrays.copyOfRange(parameters, 0, values.length - 1);
                    break;
                }
                case PAGINATION: {
                    queryString = IgniteQueryGenerator.addPaging(new StringBuilder(queryString), (Pageable)values[values.length - 1]).toString();
                    if (!qry.isAutogenerated()) break;
                    parameters = Arrays.copyOfRange(parameters, 0, values.length - 1);
                    break;
                }
            }
            if (qry.isFieldQuery()) {
                SqlFieldsQuery sqlFieldsQry = new SqlFieldsQuery(queryString);
                sqlFieldsQry.setArgs(parameters);
                sqlFieldsQry.setCollocated(config.collocated());
                sqlFieldsQry.setDistributedJoins(config.distributedJoins());
                sqlFieldsQry.setEnforceJoinOrder(config.enforceJoinOrder());
                sqlFieldsQry.setLazy(config.lazy());
                sqlFieldsQry.setLocal(config.local());
                if (config.parts() != null && config.parts().length > 0) {
                    sqlFieldsQry.setPartitions(config.parts());
                }
                sqlFieldsQry.setTimeout(config.timeout(), TimeUnit.MILLISECONDS);
                query = sqlFieldsQry;
            } else {
                SqlQuery sqlQry = new SqlQuery(this.type, queryString);
                sqlQry.setArgs(parameters);
                sqlQry.setDistributedJoins(config.distributedJoins());
                sqlQry.setLocal(config.local());
                if (config.parts() != null && config.parts().length > 0) {
                    sqlQry.setPartitions(config.parts());
                }
                sqlQry.setTimeout(config.timeout(), TimeUnit.MILLISECONDS);
                query = sqlQry;
            }
        } else {
            int pageSize = -1;
            switch (qry.options()) {
                case PAGINATION: {
                    pageSize = ((Pageable)parameters[parameters.length - 1]).getPageSize();
                }
            }
            if (queryString.contains("#{")) {
                EvaluationContext queryEvalContext = this.queryMethodEvaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), values);
                Object eval = this.expressionParser.parseExpression(queryString, ParserContext.TEMPLATE_EXPRESSION).getValue(queryEvalContext);
                if (!(eval instanceof String)) {
                    throw new IllegalStateException("TextQuery with SpEL expressions must produce a String response, but found " + eval.getClass().getName() + ". Please, check your expression: " + queryString);
                }
                queryString = (String)eval;
            }
            TextQuery textQuery = new TextQuery(this.type, queryString, config.limit());
            textQuery.setLocal(config.local());
            if (pageSize > -1) {
                textQuery.setPageSize(pageSize);
            }
            query = textQuery;
        }
        return query;
    }

    private static Map<String, Object> rowToMap(List<?> row, List<GridQueryFieldMetadata> meta) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < meta.size(); ++i) {
            String metaField = meta.get(i).fieldName().toLowerCase();
            if (metaField.equalsIgnoreCase("_KEY") || metaField.equalsIgnoreCase("_VAL")) continue;
            map.put(metaField, row.get(i));
        }
        return map;
    }

    private <V> V rowToEntity(IgniteBinaryImpl binary, BinaryType binType, List<?> row, List<GridQueryFieldMetadata> meta) {
        TreeMap metadata = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        BinaryObjectBuilder bldr = binary.builder(binType.typeName());
        for (int i = 0; i < row.size(); ++i) {
            GridQueryFieldMetadata fMeta = meta.get(i);
            String metaField = fMeta.fieldName();
            if (binType.field(fMeta.fieldName()) != null && !metaField.equalsIgnoreCase("_KEY") && !metaField.equalsIgnoreCase("_VAL")) {
                Object fieldValue = row.get(i);
                if (fieldValue == null) continue;
                Class<?> clazz = this.getClassForBinaryField(binary, binType, fMeta);
                bldr.setField(metaField, IgniteRepositoryQuery.fixExpectedType(fieldValue, clazz));
                continue;
            }
            if (metaField.equalsIgnoreCase("_KEY") || metaField.equalsIgnoreCase("_VAL")) continue;
            metadata.put(metaField, row.get(i));
        }
        return (V)bldr.build().deserialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getClassForBinaryField(IgniteBinaryImpl binary, BinaryType binType, GridQueryFieldMetadata fieldMeta) {
        try {
            String fieldId = fieldMeta.schemaName() + "." + fieldMeta.typeName() + "." + fieldMeta.fieldName();
            if (binaryFieldClass.containsKey(fieldId)) {
                return binaryFieldClass.get(fieldId);
            }
            Class clazz = null;
            TreeMap<String, Class<?>> treeMap = binaryFieldClass;
            synchronized (treeMap) {
                if (binaryFieldClass.containsKey(fieldId)) {
                    return binaryFieldClass.get(fieldId);
                }
                String fieldName = null;
                for (String fname : binType.fieldNames()) {
                    if (!fname.equalsIgnoreCase(fieldMeta.fieldName())) continue;
                    fieldName = fname;
                    break;
                }
                CacheObjectBinaryProcessorImpl proc = (CacheObjectBinaryProcessorImpl)binary.processor();
                clazz = BinaryUtils.resolveClass((BinaryContext)proc.binaryContext(), (int)binary.typeId(binType.fieldTypeName(fieldName)), (String)fieldMeta.fieldTypeName(), (ClassLoader)this.ignite.configuration().getClassLoader(), (boolean)true);
                binaryFieldClass.put(fieldId, clazz);
            }
            return clazz;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void checkRequiredPageable(ReturnStrategy returnStgy, Object[] prmtrs) {
        try {
            if (returnStgy == ReturnStrategy.PAGE_OF_VALUES || returnStgy == ReturnStrategy.SLICE_OF_VALUES || returnStgy == ReturnStrategy.SLICE_OF_CACHE_ENTRIES) {
                Pageable page = (Pageable)prmtrs[prmtrs.length - 1];
                page.isPaged();
            }
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalStateException("For " + returnStgy.name() + " you must provide on last method parameter a non null Pageable instance");
        }
    }

    private static void registerClassOnMarshaller(GridKernalContext ctx, Class<?> clazz) {
        try {
            if (!U.isJdk(clazz)) {
                U.marshal((GridKernalContext)ctx, clazz.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class QueryCursorWrapper<T, V>
    extends AbstractCollection<V>
    implements QueryCursor<V> {
        private final QueryCursor<T> delegate;
        private final Function<T, V> transformer;

        public QueryCursorWrapper(QueryCursor<T> delegate, Function<T, V> transformer) {
            this.delegate = delegate;
            this.transformer = transformer;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator it = this.delegate.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    if (!it.hasNext()) {
                        U.closeQuiet((AutoCloseable)delegate);
                        return false;
                    }
                    return true;
                }

                @Override
                public V next() {
                    Object r = transformer.apply(it.next());
                    if (r != null) {
                        return r;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public void close() {
            U.closeQuiet(this.delegate);
        }

        public List<V> getAll() {
            ArrayList data = new ArrayList();
            this.delegate.forEach(i -> data.add(this.transformer.apply(i)));
            U.closeQuiet(this.delegate);
            return data;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static enum ReturnStrategy {
        ONE_VALUE,
        CACHE_ENTRY,
        LIST_OF_CACHE_ENTRIES,
        LIST_OF_VALUES,
        LIST_OF_LISTS,
        SLICE_OF_VALUES,
        SLICE_OF_CACHE_ENTRIES,
        SLICE_OF_LISTS,
        PAGE_OF_VALUES,
        STREAM_OF_VALUES;

    }
}

