/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.config;

import org.apache.ignite.springdata20.repository.config.Query;

public class DynamicQueryConfig {
    private String value = "";
    private boolean textQuery;
    private boolean forceFieldsQry;
    private boolean collocated;
    private int timeout;
    private boolean enforceJoinOrder;
    private boolean distributedJoins;
    private boolean lazy;
    private boolean local;
    private int[] parts;
    private int limit;

    public static DynamicQueryConfig fromQueryAnnotation(Query queryConfiguration) {
        DynamicQueryConfig config = new DynamicQueryConfig();
        if (queryConfiguration != null) {
            config.value = queryConfiguration.value();
            config.collocated = queryConfiguration.collocated();
            config.timeout = queryConfiguration.timeout();
            config.enforceJoinOrder = queryConfiguration.enforceJoinOrder();
            config.distributedJoins = queryConfiguration.distributedJoins();
            config.lazy = queryConfiguration.lazy();
            config.parts = queryConfiguration.parts();
            config.local = queryConfiguration.local();
            config.limit = queryConfiguration.limit();
        }
        return config;
    }

    public String value() {
        return this.value;
    }

    public boolean textQuery() {
        return this.textQuery;
    }

    public boolean forceFieldsQuery() {
        return this.forceFieldsQry;
    }

    public boolean collocated() {
        return this.collocated;
    }

    public int timeout() {
        return this.timeout;
    }

    public boolean enforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean lazy() {
        return this.lazy;
    }

    public boolean local() {
        return this.local;
    }

    public int[] parts() {
        return this.parts;
    }

    public int limit() {
        return this.limit;
    }

    public DynamicQueryConfig setValue(String value) {
        this.value = value;
        return this;
    }

    public DynamicQueryConfig setTextQuery(boolean textQuery) {
        this.textQuery = textQuery;
        return this;
    }

    public DynamicQueryConfig setForceFieldsQuery(boolean forceFieldsQuery) {
        this.forceFieldsQry = forceFieldsQuery;
        return this;
    }

    public DynamicQueryConfig setCollocated(boolean collocated) {
        this.collocated = collocated;
        return this;
    }

    public DynamicQueryConfig setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public DynamicQueryConfig setEnforceJoinOrder(boolean enforceJoinOrder) {
        this.enforceJoinOrder = enforceJoinOrder;
        return this;
    }

    public DynamicQueryConfig setDistributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
        return this;
    }

    public DynamicQueryConfig setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public DynamicQueryConfig setLocal(boolean local) {
        this.local = local;
        return this;
    }

    public DynamicQueryConfig setParts(int[] parts) {
        this.parts = parts;
        return this;
    }

    public DynamicQueryConfig setLimit(int limit) {
        this.limit = limit;
        return this;
    }
}

