/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.net.InetSocketAddress;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerNioListener;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.jetbrains.annotations.Nullable;

public class ClientConnectionView {
    private final GridNioSession ses;
    @Nullable
    private final ClientListenerConnectionContext ctx;

    public ClientConnectionView(GridNioSession ses) {
        this.ses = ses;
        this.ctx = (ClientListenerConnectionContext)ses.meta(ClientListenerNioListener.CONN_CTX_META_KEY);
    }

    public long connectionId() {
        if (this.ctx == null) {
            return -1L;
        }
        return this.ctx.connectionId();
    }

    public String type() {
        if (this.ctx == null) {
            return null;
        }
        if (this.ctx instanceof OdbcConnectionContext) {
            return "ODBC";
        }
        if (this.ctx instanceof JdbcConnectionContext) {
            return "JDBC";
        }
        if (this.ctx instanceof ClientConnectionContext) {
            return "THIN";
        }
        return "unknown";
    }

    public InetSocketAddress localAddress() {
        return this.ses.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return this.ses.remoteAddress();
    }

    public String user() {
        if (this.ctx == null) {
            return null;
        }
        AuthorizationContext authCtx = this.ctx.authorizationContext();
        return authCtx == null ? null : authCtx.userName();
    }

    public String version() {
        if (this.ctx == null) {
            return null;
        }
        ClientListenerRequestHandler hnd = this.ctx.handler();
        if (hnd == null) {
            return null;
        }
        ClientListenerProtocolVersion ver = hnd.protocolVersion();
        return ver == null ? null : ver.asString();
    }
}

