/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.PlatformConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.cluster.DetachedClusterNode;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongImpl;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformAsyncResult;
import org.apache.ignite.internal.processors.platform.PlatformConfigurationEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformContextImpl;
import org.apache.ignite.internal.processors.platform.PlatformLock;
import org.apache.ignite.internal.processors.platform.PlatformPluginExtension;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxyImpl;
import org.apache.ignite.internal.processors.platform.binary.PlatformBinaryProcessor;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheExtension;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheManager;
import org.apache.ignite.internal.processors.platform.cache.affinity.PlatformAffinity;
import org.apache.ignite.internal.processors.platform.cache.store.PlatformCacheStore;
import org.apache.ignite.internal.processors.platform.cluster.PlatformClusterGroup;
import org.apache.ignite.internal.processors.platform.datastreamer.PlatformDataStreamer;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicLong;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicReference;
import org.apache.ignite.internal.processors.platform.datastructures.PlatformAtomicSequence;
import org.apache.ignite.internal.processors.platform.dotnet.PlatformDotNetCacheStore;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.transactions.PlatformTransactions;
import org.apache.ignite.internal.processors.platform.utils.PlatformConfigurationUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class PlatformProcessorImpl
extends GridProcessorAdapter
implements PlatformProcessor,
PlatformTarget {
    private static final int OP_GET_CACHE = 1;
    private static final int OP_CREATE_CACHE = 2;
    private static final int OP_GET_OR_CREATE_CACHE = 3;
    private static final int OP_CREATE_CACHE_FROM_CONFIG = 4;
    private static final int OP_GET_OR_CREATE_CACHE_FROM_CONFIG = 5;
    private static final int OP_DESTROY_CACHE = 6;
    private static final int OP_GET_AFFINITY = 7;
    private static final int OP_GET_DATA_STREAMER = 8;
    private static final int OP_GET_TRANSACTIONS = 9;
    private static final int OP_GET_CLUSTER_GROUP = 10;
    private static final int OP_GET_EXTENSION = 11;
    private static final int OP_GET_ATOMIC_LONG = 12;
    private static final int OP_GET_ATOMIC_REFERENCE = 13;
    private static final int OP_GET_ATOMIC_SEQUENCE = 14;
    private static final int OP_GET_IGNITE_CONFIGURATION = 15;
    private static final int OP_GET_CACHE_NAMES = 16;
    private static final int OP_CREATE_NEAR_CACHE = 17;
    private static final int OP_GET_OR_CREATE_NEAR_CACHE = 18;
    private static final int OP_LOGGER_IS_LEVEL_ENABLED = 19;
    private static final int OP_LOGGER_LOG = 20;
    private static final int OP_GET_BINARY_PROCESSOR = 21;
    private static final int OP_RELEASE_START = 22;
    private static final int OP_ADD_CACHE_CONFIGURATION = 23;
    private static final int OP_SET_BASELINE_TOPOLOGY_VER = 24;
    private static final int OP_SET_BASELINE_TOPOLOGY_NODES = 25;
    private static final int OP_GET_BASELINE_TOPOLOGY = 26;
    private static final int OP_DISABLE_WAL = 27;
    private static final int OP_ENABLE_WAL = 28;
    private static final int OP_IS_WAL_ENABLED = 29;
    private static final int OP_SET_TX_TIMEOUT_ON_PME = 30;
    private static final int OP_NODE_VERSION = 31;
    private static final int OP_IS_BASELINE_AUTO_ADJ_ENABLED = 32;
    private static final int OP_SET_BASELINE_AUTO_ADJ_ENABLED = 33;
    private static final int OP_GET_BASELINE_AUTO_ADJ_TIMEOUT = 34;
    private static final int OP_SET_BASELINE_AUTO_ADJ_TIMEOUT = 35;
    private static final int OP_GET_CACHE_CONFIG = 36;
    private static final int OP_GET_THREAD_LOCAL = 37;
    private static final int OP_GET_OR_CREATE_LOCK = 38;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final Collection<StoreInfo> pendingStores = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReadWriteLock storeLock = new ReentrantReadWriteLock();
    private final IgniteLogger log;
    private final PlatformContext platformCtx;
    private final PlatformConfigurationEx interopCfg;
    private final PlatformPluginExtension[] extensions;
    private boolean started;
    private volatile boolean stopped;
    private final PlatformCacheExtension[] cacheExts;
    private volatile boolean clusterRestarted;
    private final ThreadLocal<Object> threadLocal = new ThreadLocal();

    public PlatformProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        this.log = ctx.log(PlatformProcessorImpl.class);
        PlatformConfiguration interopCfg0 = ctx.config().getPlatformConfiguration();
        assert (interopCfg0 != null) : "Must be checked earlier during component creation.";
        if (!(interopCfg0 instanceof PlatformConfigurationEx)) {
            throw new IgniteException("Unsupported platform configuration: " + interopCfg0.getClass().getName());
        }
        this.interopCfg = (PlatformConfigurationEx)((Object)interopCfg0);
        if (!F.isEmpty(this.interopCfg.warnings())) {
            for (String w : this.interopCfg.warnings()) {
                U.warn(this.log, w);
            }
        }
        this.platformCtx = new PlatformContextImpl(ctx, this.interopCfg.gate(), this.interopCfg.memory(), this.interopCfg.platform());
        this.cacheExts = PlatformProcessorImpl.prepareCacheExtensions(this.interopCfg.cacheExtensions());
        if (this.interopCfg.logger() != null) {
            this.interopCfg.logger().setContext(this.platformCtx);
        }
        this.extensions = PlatformProcessorImpl.prepareExtensions((PlatformPluginExtension[])ctx.plugins().extensions(PlatformPluginExtension.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteCheckedException {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeString(this.ctx.igniteInstanceName());
            out.synchronize();
            this.platformCtx.gateway().onStart(new PlatformTargetProxyImpl(this, this.platformCtx), mem.pointer());
        }
        this.storeLock.writeLock().lock();
        try {
            for (StoreInfo store : this.pendingStores) {
                this.registerStore0(store.store, store.convertBinary);
            }
            this.pendingStores.clear();
            this.started = true;
        }
        finally {
            this.storeLock.writeLock().unlock();
        }
        this.ctx.addNodeAttribute("org.apache.ignite.platform", this.interopCfg.platform());
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.startLatch.countDown();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.platformCtx != null) {
            this.stopped = true;
            this.platformCtx.gateway().onStop();
        }
    }

    @Override
    public Ignite ignite() {
        return this.ctx.grid();
    }

    @Override
    public long environmentPointer() {
        return this.platformCtx.gateway().environmentPointer();
    }

    @Override
    public void releaseStart() {
        this.startLatch.countDown();
    }

    @Override
    public void awaitStart() throws IgniteCheckedException {
        U.await(this.startLatch);
    }

    @Override
    public PlatformContext context() {
        return this.platformCtx;
    }

    @Override
    public boolean hasContext() {
        return true;
    }

    @Override
    public void registerStore(PlatformCacheStore store, boolean convertBinary) throws IgniteCheckedException {
        this.storeLock.readLock().lock();
        try {
            if (this.stopped) {
                throw new IgniteCheckedException("Failed to initialize interop store because node is stopping: " + store);
            }
            if (this.started) {
                this.registerStore0(store, convertBinary);
            } else {
                this.pendingStores.add(new StoreInfo(store, convertBinary));
            }
        }
        finally {
            this.storeLock.readLock().unlock();
        }
    }

    @Override
    public PlatformCacheManager cacheManager() {
        return new PlatformCacheManager(this.platformCtx.gateway());
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.platformCtx.gateway().onClientDisconnected();
        reconnectFut.listen(new CI1<IgniteFuture<?>>(){

            @Override
            public void apply(IgniteFuture<?> future) {
                PlatformProcessorImpl.this.platformCtx.gateway().onClientReconnected(PlatformProcessorImpl.this.clusterRestarted);
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.clusterRestarted = clusterRestarted;
        return null;
    }

    private PlatformTarget createPlatformCache(IgniteCacheProxy cache) {
        assert (cache != null);
        return new PlatformCache(this.platformCtx, cache, false, this.cacheExts);
    }

    private boolean loggerIsLevelEnabled(int level) {
        IgniteLogger log = this.ctx.grid().log();
        switch (level) {
            case 0: {
                return log.isTraceEnabled();
            }
            case 1: {
                return log.isDebugEnabled();
            }
            case 2: {
                return log.isInfoEnabled();
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    private void loggerLog(int level, String message, String category, String errorInfo) {
        IgniteLogger log = this.ctx.grid().log();
        if (category != null) {
            log = log.getLogger(category);
        }
        IgniteException err = errorInfo == null ? null : new IgniteException("Platform error:" + errorInfo);
        switch (level) {
            case 0: {
                log.trace(message);
                break;
            }
            case 1: {
                log.debug(message);
                break;
            }
            case 2: {
                log.info(message);
                break;
            }
            case 3: {
                log.warning(message, err);
                break;
            }
            case 4: {
                log.error(message, err);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 19: {
                return this.loggerIsLevelEnabled((int)val) ? 1L : 0L;
            }
            case 22: {
                this.releaseStart();
                return 0L;
            }
            case 24: {
                this.ctx.grid().cluster().setBaselineTopology(val);
                return 0L;
            }
            case 35: {
                this.ctx.grid().cluster().baselineAutoAdjustTimeout(val);
                return 0L;
            }
        }
        return (Long)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 6: {
                this.ctx.grid().destroyCache(reader.readString());
                return 0L;
            }
            case 20: {
                this.loggerLog(reader.readInt(), reader.readString(), reader.readString(), reader.readString());
                return 0L;
            }
            case 25: {
                int cnt = reader.readInt();
                ArrayList<DetachedClusterNode> nodes = new ArrayList<DetachedClusterNode>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    Object consId = reader.readObjectDetached();
                    Map<String, Object> attrs = PlatformUtils.readNodeAttributes(reader);
                    nodes.add(new DetachedClusterNode(consId, attrs));
                }
                this.ctx.grid().cluster().setBaselineTopology(nodes);
                return 0L;
            }
            case 23: {
                CacheConfiguration cfg = PlatformConfigurationUtils.readCacheConfiguration(reader);
                this.ctx.grid().addCacheConfiguration(cfg);
                return 0L;
            }
            case 27: {
                this.ctx.grid().cluster().disableWal(reader.readString());
                return 0L;
            }
            case 28: {
                this.ctx.grid().cluster().enableWal(reader.readString());
                return 0L;
            }
            case 30: {
                this.ctx.grid().cluster().setTxTimeoutOnPartitionMapExchange(reader.readLong());
                return 0L;
            }
            case 29: {
                return this.ctx.grid().cluster().isWalEnabled(reader.readString()) ? 1L : 0L;
            }
            case 32: {
                return this.ctx.grid().cluster().isBaselineAutoAdjustEnabled() ? 1L : 0L;
            }
            case 33: {
                boolean isEnabled = reader.readBoolean();
                this.ctx.grid().cluster().baselineAutoAdjustEnabled(isEnabled);
                return 0L;
            }
            case 34: {
                return this.ctx.grid().cluster().baselineAutoAdjustTimeout();
            }
        }
        return (Long)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader, PlatformMemory mem) throws IgniteCheckedException {
        return this.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 36) {
            int cacheId = reader.readInt();
            CacheConfiguration cfg = this.ctx.cache().cacheDescriptor(cacheId).cacheConfiguration();
            PlatformConfigurationUtils.writeCacheConfiguration(writer, cfg);
            return;
        }
        PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                String name = reader.readString();
                IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().cache(name);
                if (cache == null) {
                    throw new IllegalArgumentException("Cache doesn't exist: " + name);
                }
                return this.createPlatformCache(cache);
            }
            case 2: {
                String name = reader.readString();
                IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().createCache(name);
                return this.createPlatformCache(cache);
            }
            case 3: {
                String name = reader.readString();
                IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(name);
                return this.createPlatformCache(cache);
            }
            case 4: {
                CacheConfiguration cfg = PlatformConfigurationUtils.readCacheConfiguration(reader);
                IgniteCacheProxy cache = reader.readBoolean() ? (IgniteCacheProxy)this.ctx.grid().createCache(cfg, PlatformConfigurationUtils.readNearConfiguration(reader)) : (IgniteCacheProxy)this.ctx.grid().createCache(cfg);
                PlatformProcessorImpl.setPlatformCache(reader, cache);
                return this.createPlatformCache(cache);
            }
            case 5: {
                CacheConfiguration cfg = PlatformConfigurationUtils.readCacheConfiguration(reader);
                IgniteCacheProxy cache = reader.readBoolean() ? (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(cfg, PlatformConfigurationUtils.readNearConfiguration(reader)) : (IgniteCacheProxy)this.ctx.grid().getOrCreateCache(cfg);
                PlatformProcessorImpl.setPlatformCache(reader, cache);
                return this.createPlatformCache(cache);
            }
            case 7: {
                return new PlatformAffinity(this.platformCtx, this.ctx, reader.readString());
            }
            case 8: {
                String cacheName = reader.readString();
                boolean keepBinary = reader.readBoolean();
                DataStreamerImpl ldr = this.ctx.dataStream().dataStreamer(cacheName);
                ldr.keepBinary(true);
                return new PlatformDataStreamer(this.platformCtx, cacheName, ldr, keepBinary);
            }
            case 11: {
                PlatformPluginExtension ext;
                int id = reader.readInt();
                if (this.extensions != null && id < this.extensions.length && (ext = this.extensions[id]) != null) {
                    return ext.createTarget();
                }
                throw new IgniteException("Platform extension is not registered [id=" + id + ']');
            }
            case 12: {
                String name = reader.readString();
                long initVal = reader.readLong();
                boolean create = reader.readBoolean();
                GridCacheAtomicLongImpl atomicLong = (GridCacheAtomicLongImpl)this.ignite().atomicLong(name, initVal, create);
                if (atomicLong == null) {
                    return null;
                }
                return new PlatformAtomicLong(this.platformCtx, atomicLong);
            }
            case 13: {
                String name = reader.readString();
                Object initVal = reader.readObjectDetached();
                boolean create = reader.readBoolean();
                return PlatformAtomicReference.createInstance(this.platformCtx, name, initVal, create);
            }
            case 14: {
                String name = reader.readString();
                long initVal = reader.readLong();
                boolean create = reader.readBoolean();
                IgniteAtomicSequence atomicSeq = this.ignite().atomicSequence(name, initVal, create);
                if (atomicSeq == null) {
                    return null;
                }
                return new PlatformAtomicSequence(this.platformCtx, atomicSeq);
            }
            case 17: {
                String cacheName = reader.readString();
                NearCacheConfiguration cfg = PlatformConfigurationUtils.readNearConfiguration(reader);
                IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().createNearCache(cacheName, cfg);
                PlatformProcessorImpl.setPlatformCache(reader, cache);
                return this.createPlatformCache(cache);
            }
            case 18: {
                String cacheName = reader.readString();
                NearCacheConfiguration cfg = PlatformConfigurationUtils.readNearConfiguration(reader);
                IgniteCacheProxy cache = (IgniteCacheProxy)this.ctx.grid().getOrCreateNearCache(cacheName, cfg);
                PlatformProcessorImpl.setPlatformCache(reader, cache);
                return this.createPlatformCache(cache);
            }
            case 9: {
                String lbl = reader.readString();
                return new PlatformTransactions(this.platformCtx, lbl);
            }
            case 38: {
                String name = reader.readString();
                boolean failoverSafe = reader.readBoolean();
                boolean fair = reader.readBoolean();
                boolean create = reader.readBoolean();
                IgniteLock lock = this.ctx.grid().reentrantLock(name, failoverSafe, fair, create);
                return lock == null ? null : new PlatformLock(this.platformCtx, lock);
            }
        }
        return (PlatformTarget)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processInObjectStreamOutObjectStream(int type, @Nullable PlatformTarget arg, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        return (PlatformTarget)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 15: {
                PlatformConfigurationUtils.writeIgniteConfiguration(writer, this.ignite().configuration());
                return;
            }
            case 16: {
                Collection<String> names = this.ignite().cacheNames();
                writer.writeInt(names.size());
                for (String name : names) {
                    writer.writeString(name);
                }
                return;
            }
            case 26: {
                Collection<BaselineNode> blt = this.ignite().cluster().currentBaselineTopology();
                writer.writeInt(blt.size());
                for (BaselineNode n : blt) {
                    writer.writeObjectDetached(n.consistentId());
                    PlatformUtils.writeNodeAttributes(writer, n.attributes());
                }
                return;
            }
            case 31: {
                IgniteProductVersion productVersion = this.ignite().cluster().node().version();
                PlatformUtils.writeNodeVersion(writer, productVersion);
                return;
            }
            case 37: {
                writer.writeObjectDetached(this.threadLocal.get());
                return;
            }
        }
        PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 9: {
                return new PlatformTransactions(this.platformCtx);
            }
            case 10: {
                return new PlatformClusterGroup(this.platformCtx, this.ctx.grid().cluster());
            }
            case 21: {
                return new PlatformBinaryProcessor(this.platformCtx);
            }
        }
        return (PlatformTarget)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public PlatformAsyncResult processInStreamAsync(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        return (PlatformAsyncResult)PlatformAbstractTarget.throwUnsupported(type);
    }

    @Override
    public Exception convertException(Exception e) {
        return e;
    }

    @Override
    public void setThreadLocal(Object value) {
        this.threadLocal.set(value);
    }

    private void registerStore0(PlatformCacheStore store, boolean convertBinary) throws IgniteCheckedException {
        if (!(store instanceof PlatformDotNetCacheStore)) {
            throw new IgniteCheckedException("Unsupported interop store: " + store);
        }
        PlatformDotNetCacheStore store0 = (PlatformDotNetCacheStore)store;
        store0.initialize(this.ctx, convertBinary);
    }

    private static void setPlatformCache(BinaryRawReaderEx reader, IgniteCacheProxy cache) {
        if (reader.readBoolean()) {
            cache.context().cache().configuration().setPlatformCacheConfiguration(PlatformConfigurationUtils.readPlatformCacheConfiguration(reader));
        }
    }

    private static PlatformCacheExtension[] prepareCacheExtensions(Collection<PlatformCacheExtension> cacheExts) {
        if (!F.isEmpty(cacheExts)) {
            int maxExtId = 0;
            HashMap<Integer, PlatformCacheExtension> idToExt = new HashMap<Integer, PlatformCacheExtension>();
            for (PlatformCacheExtension cacheExt : cacheExts) {
                if (cacheExt == null) {
                    throw new IgniteException("Platform cache extension cannot be null.");
                }
                if (cacheExt.id() < 0) {
                    throw new IgniteException("Platform cache extension ID cannot be negative: " + cacheExt);
                }
                PlatformCacheExtension oldCacheExt = idToExt.put(cacheExt.id(), cacheExt);
                if (oldCacheExt != null) {
                    throw new IgniteException("Platform cache extensions cannot have the same ID [id=" + cacheExt.id() + ", first=" + oldCacheExt + ", second=" + cacheExt + ']');
                }
                if (cacheExt.id() <= maxExtId) continue;
                maxExtId = cacheExt.id();
            }
            PlatformCacheExtension[] res = new PlatformCacheExtension[maxExtId + 1];
            Iterator<PlatformCacheExtension> iterator = cacheExts.iterator();
            while (iterator.hasNext()) {
                PlatformCacheExtension cacheExt;
                res[cacheExt.id()] = cacheExt = iterator.next();
            }
            return res;
        }
        return new PlatformCacheExtension[0];
    }

    private static PlatformPluginExtension[] prepareExtensions(PlatformPluginExtension[] exts) {
        if (!F.isEmpty(exts)) {
            int maxExtId = 0;
            HashMap<Integer, PlatformPluginExtension> idToExt = new HashMap<Integer, PlatformPluginExtension>();
            for (PlatformPluginExtension ext : exts) {
                if (ext == null) {
                    throw new IgniteException("Platform extension cannot be null.");
                }
                if (ext.id() < 0) {
                    throw new IgniteException("Platform extension ID cannot be negative: " + ext);
                }
                PlatformPluginExtension oldCacheExt = idToExt.put(ext.id(), ext);
                if (oldCacheExt != null) {
                    throw new IgniteException("Platform extensions cannot have the same ID [id=" + ext.id() + ", first=" + oldCacheExt + ", second=" + ext + ']');
                }
                if (ext.id() <= maxExtId) continue;
                maxExtId = ext.id();
            }
            PlatformPluginExtension[] res = new PlatformPluginExtension[maxExtId + 1];
            PlatformPluginExtension[] platformPluginExtensionArray = exts;
            int n = platformPluginExtensionArray.length;
            for (int i = 0; i < n; ++i) {
                PlatformPluginExtension ext;
                res[ext.id()] = ext = platformPluginExtensionArray[i];
            }
            return res;
        }
        return new PlatformPluginExtension[0];
    }

    private static class StoreInfo {
        private final PlatformCacheStore store;
        private final boolean convertBinary;

        private StoreInfo(PlatformCacheStore store, boolean convertBinary) {
            this.store = store;
            this.convertBinary = convertBinary;
        }
    }
}

