/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.jetbrains.annotations.Nullable;

public class JdbcUtils {
    public static void writeItems(BinaryWriterExImpl writer, List<List<Object>> items, JdbcProtocolContext protoCtx) {
        writer.writeInt(items.size());
        for (List<Object> row : items) {
            if (row == null) continue;
            writer.writeInt(row.size());
            for (Object obj : row) {
                JdbcUtils.writeObject(writer, obj, protoCtx);
            }
        }
    }

    public static List<List<Object>> readItems(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) {
        int rowsSize = reader.readInt();
        if (rowsSize > 0) {
            ArrayList<List<Object>> items = new ArrayList<List<Object>>(rowsSize);
            for (int i = 0; i < rowsSize; ++i) {
                int colsSize = reader.readInt();
                ArrayList<Object> col = new ArrayList<Object>(colsSize);
                for (int colCnt = 0; colCnt < colsSize; ++colCnt) {
                    col.add(JdbcUtils.readObject(reader, protoCtx));
                }
                items.add(col);
            }
            return items;
        }
        return Collections.emptyList();
    }

    public static void writeStringCollection(BinaryWriterExImpl writer, Collection<String> lst) {
        if (lst == null) {
            writer.writeInt(0);
        } else {
            writer.writeInt(lst.size());
            for (String s : lst) {
                writer.writeString(s);
            }
        }
    }

    public static List<String> readStringList(BinaryReaderExImpl reader) {
        int size = reader.readInt();
        if (size > 0) {
            ArrayList<String> lst = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                lst.add(reader.readString());
            }
            return lst;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static Integer readNullableInteger(BinaryReaderExImpl reader) {
        return reader.readBoolean() ? Integer.valueOf(reader.readInt()) : null;
    }

    public static void writeNullableInteger(BinaryWriterExImpl writer, @Nullable Integer val) {
        writer.writeBoolean(val != null);
        if (val != null) {
            writer.writeInt(val);
        }
    }

    @Nullable
    public static Object readObject(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        return SqlListenerUtils.readObject(reader.readByte(), reader, protoCtx.isFeatureSupported(JdbcThinFeature.CUSTOM_OBJECT), protoCtx.keepBinary());
    }

    public static void writeObject(BinaryWriterExImpl writer, @Nullable Object obj, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        if (obj == null) {
            writer.writeByte((byte)101);
            return;
        }
        SqlListenerUtils.writeObject(writer, obj, protoCtx.isFeatureSupported(JdbcThinFeature.CUSTOM_OBJECT));
    }
}

