/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.configuration.distributed;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.configuration.distributed.DetachedPropertyException;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.NotWritablePropertyException;
import org.apache.ignite.internal.processors.configuration.distributed.PropertyUpdateClosure;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class SimpleDistributedProperty<T extends Serializable>
implements DistributedChangeableProperty<T> {
    private final String name;
    protected volatile T val;
    private volatile boolean attached = false;
    private final ConcurrentLinkedQueue<DistributePropertyListener<? super T>> updateListeners = new ConcurrentLinkedQueue();
    @GridToStringExclude
    private volatile PropertyUpdateClosure clusterWideUpdater;

    public SimpleDistributedProperty(String name) {
        this.name = name;
    }

    @Override
    public boolean propagate(T newVal) throws IgniteCheckedException {
        this.ensureClusterWideUpdateIsReady();
        this.clusterWideUpdater.update(this.name, (Serializable)newVal).get();
        return true;
    }

    private void ensureClusterWideUpdateIsReady() throws DetachedPropertyException, NotWritablePropertyException {
        if (!this.attached) {
            throw new DetachedPropertyException(this.name);
        }
        if (this.clusterWideUpdater == null) {
            throw new NotWritablePropertyException(this.name);
        }
    }

    @Override
    public GridFutureAdapter<?> propagateAsync(T newVal) throws IgniteCheckedException {
        this.ensureClusterWideUpdateIsReady();
        return this.clusterWideUpdater.update(this.name, (Serializable)newVal);
    }

    @Override
    public GridFutureAdapter<?> propagateAsync(T expectedVal, T newVal) throws IgniteCheckedException {
        this.ensureClusterWideUpdateIsReady();
        return this.clusterWideUpdater.casUpdate(this.name, (Serializable)expectedVal, (Serializable)newVal);
    }

    @Override
    public T get() {
        return this.val;
    }

    @Override
    public T getOrDefault(T dfltVal) {
        return this.val == null ? dfltVal : this.val;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(DistributePropertyListener<? super T> listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void onAttached() {
        this.attached = true;
    }

    @Override
    public void onReadyForUpdate(@NotNull PropertyUpdateClosure updater) {
        this.clusterWideUpdater = updater;
    }

    @Override
    public void localUpdate(Serializable newVal) {
        T oldVal = this.val;
        this.val = newVal;
        this.updateListeners.forEach((Consumer<DistributePropertyListener<T>>)((Consumer<DistributePropertyListener>)listener -> listener.onUpdate(this.name, oldVal, this.val)));
    }

    public String toString() {
        return S.toString(SimpleDistributedProperty.class, this);
    }
}

