/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Collection;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;

public class DataStorageMetricsImpl
implements DataStorageMetricsMXBean {
    public static final String DATASTORAGE_METRIC_PREFIX = "io.datastorage";
    private final HitRateMetric walLoggingRate;
    private final HitRateMetric walWritingRate;
    private final HitRateMetric walFsyncTimeDuration;
    private final HitRateMetric walFsyncTimeNum;
    private final HitRateMetric walBuffPollSpinsNum;
    private final AtomicLongMetric lastCpLockWaitDuration;
    private final AtomicLongMetric lastCpMarkDuration;
    private final AtomicLongMetric lastCpPagesWriteDuration;
    private final AtomicLongMetric lastCpDuration;
    private final AtomicLongMetric lastCpFsyncDuration;
    private final AtomicLongMetric lastCpTotalPages;
    private final AtomicLongMetric lastCpDataPages;
    private final AtomicLongMetric lastCpCowPages;
    private volatile long rateTimeInterval;
    private volatile int subInts;
    private volatile boolean metricsEnabled;
    private volatile IgniteWriteAheadLogManager wal;
    private volatile IgniteOutClosure<Long> walSizeProvider;
    private final AtomicLongMetric lastWalSegmentRollOverTime;
    private final AtomicLongMetric totalCheckpointTime;
    private volatile Collection<DataRegionMetrics> regionMetrics;
    private final AtomicLongMetric storageSize;
    private final AtomicLongMetric sparseStorageSize;

    public DataStorageMetricsImpl(GridMetricManager mmgr, boolean metricsEnabled, long rateTimeInterval, int subInts) {
        this.metricsEnabled = metricsEnabled;
        this.rateTimeInterval = rateTimeInterval;
        this.subInts = subInts;
        MetricRegistry mreg = mmgr.registry(DATASTORAGE_METRIC_PREFIX);
        this.walLoggingRate = mreg.hitRateMetric("WalLoggingRate", "Average number of WAL records per second written during the last time interval.", rateTimeInterval, subInts);
        this.walWritingRate = mreg.hitRateMetric("WalWritingRate", "Average number of bytes per second written during the last time interval.", rateTimeInterval, subInts);
        this.walFsyncTimeDuration = mreg.hitRateMetric("WalFsyncTimeDuration", "Total duration of fsync", rateTimeInterval, subInts);
        this.walFsyncTimeNum = mreg.hitRateMetric("WalFsyncTimeNum", "Total count of fsync", rateTimeInterval, subInts);
        this.walBuffPollSpinsNum = mreg.hitRateMetric("WalBuffPollSpinsRate", "WAL buffer poll spins number over the last time interval.", rateTimeInterval, subInts);
        this.lastCpLockWaitDuration = mreg.longMetric("LastCheckpointLockWaitDuration", "Duration of the checkpoint lock wait in milliseconds.");
        this.lastCpMarkDuration = mreg.longMetric("LastCheckpointMarkDuration", "Duration of the checkpoint lock wait in milliseconds.");
        this.lastCpPagesWriteDuration = mreg.longMetric("LastCheckpointPagesWriteDuration", "Duration of the checkpoint pages write in milliseconds.");
        this.lastCpDuration = mreg.longMetric("LastCheckpointDuration", "Duration of the last checkpoint in milliseconds.");
        this.lastCpFsyncDuration = mreg.longMetric("LastCheckpointFsyncDuration", "Duration of the sync phase of the last checkpoint in milliseconds.");
        this.lastCpTotalPages = mreg.longMetric("LastCheckpointTotalPagesNumber", "Total number of pages written during the last checkpoint.");
        this.lastCpDataPages = mreg.longMetric("LastCheckpointDataPagesNumber", "Total number of data pages written during the last checkpoint.");
        this.lastCpCowPages = mreg.longMetric("LastCheckpointCopiedOnWritePagesNumber", "Number of pages copied to a temporary checkpoint buffer during the last checkpoint.");
        this.lastWalSegmentRollOverTime = mreg.longMetric("WalLastRollOverTime", "Time of the last WAL segment rollover.");
        this.totalCheckpointTime = mreg.longMetric("CheckpointTotalTime", "Total duration of checkpoint");
        this.storageSize = mreg.longMetric("StorageSize", "Storage space allocated, in bytes.");
        this.sparseStorageSize = mreg.longMetric("SparseStorageSize", "Storage space allocated adjusted for possible sparsity, in bytes.");
        mreg.register("WalArchiveSegments", this::getWalArchiveSegments, "Current number of WAL segments in the WAL archive.");
        mreg.register("WalTotalSize", this::getWalTotalSize, "Total size in bytes for storage wal files.");
    }

    @Override
    public float getWalLoggingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walLoggingRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getWalWritingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walWritingRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public int getWalArchiveSegments() {
        if (!this.metricsEnabled) {
            return 0;
        }
        return this.wal.walArchiveSegments();
    }

    @Override
    public float getWalFsyncTimeAverage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long numRate = this.walFsyncTimeNum.value();
        if (numRate == 0L) {
            return 0.0f;
        }
        return (float)this.walFsyncTimeDuration.value() / (float)numRate;
    }

    @Override
    public long getWalBuffPollSpinsRate() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.walBuffPollSpinsNum.value();
    }

    @Override
    public long getLastCheckpointDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDuration.value();
    }

    @Override
    public long getLastCheckpointLockWaitDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpLockWaitDuration.value();
    }

    @Override
    public long getLastCheckpointMarkDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpMarkDuration.value();
    }

    @Override
    public long getLastCheckpointPagesWriteDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpPagesWriteDuration.value();
    }

    @Override
    public long getLastCheckpointFsyncDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpFsyncDuration.value();
    }

    @Override
    public long getLastCheckpointTotalPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpTotalPages.value();
    }

    @Override
    public long getLastCheckpointDataPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDataPages.value();
    }

    @Override
    public long getLastCheckpointCopiedOnWritePagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpCowPages.value();
    }

    @Override
    public void enableMetrics() {
        this.metricsEnabled = true;
    }

    @Override
    public void disableMetrics() {
        this.metricsEnabled = false;
    }

    @Override
    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.resetRates();
    }

    @Override
    public void subIntervals(int subInts) {
        this.subInts = subInts;
        this.resetRates();
    }

    @Override
    public long getWalTotalSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        IgniteOutClosure<Long> walSize = this.walSizeProvider;
        return walSize != null ? walSize.apply() : 0L;
    }

    @Override
    public long getWalLastRollOverTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastWalSegmentRollOverTime.value();
    }

    @Override
    public long getCheckpointTotalTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.totalCheckpointTime.value();
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long dirtyPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            dirtyPages += rm.getDirtyPages();
        }
        return dirtyPages;
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long readPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            readPages += rm.getPagesRead();
        }
        return readPages;
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long writtenPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            writtenPages += rm.getPagesWritten();
        }
        return writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long replacedPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            replacedPages += rm.getPagesReplaced();
        }
        return replacedPages;
    }

    @Override
    public long getOffHeapSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapSize += rm.getOffHeapSize();
        }
        return offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapUsedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapUsedSize += rm.getOffheapUsedSize();
        }
        return offHeapUsedSize;
    }

    @Override
    public long getTotalAllocatedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long totalAllocatedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            totalAllocatedSize += rm.getTotalAllocatedSize();
        }
        return totalAllocatedSize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferPages += rm.getUsedCheckpointBufferPages();
        }
        return usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferSize += rm.getUsedCheckpointBufferSize();
        }
        return usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long checkpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            checkpointBufferSize += rm.getCheckpointBufferSize();
        }
        return checkpointBufferSize;
    }

    public void wal(IgniteWriteAheadLogManager wal) {
        this.wal = wal;
    }

    public void setWalSizeProvider(IgniteOutClosure<Long> walSizeProvider) {
        this.walSizeProvider = walSizeProvider;
    }

    public void onWallRollOver() {
        this.lastWalSegmentRollOverTime.value(U.currentTimeMillis());
    }

    public void regionMetrics(Collection<DataRegionMetrics> regionMetrics) {
        this.regionMetrics = regionMetrics;
    }

    public boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public long getStorageSize() {
        return this.storageSize.value();
    }

    @Override
    public long getSparseStorageSize() {
        return this.sparseStorageSize.value();
    }

    public void onCheckpoint(long lockWaitDuration, long markDuration, long pagesWriteDuration, long fsyncDuration, long duration, long totalPages, long dataPages, long cowPages, long storageSize, long sparseStorageSize) {
        if (this.metricsEnabled) {
            this.lastCpLockWaitDuration.value(lockWaitDuration);
            this.lastCpMarkDuration.value(markDuration);
            this.lastCpPagesWriteDuration.value(pagesWriteDuration);
            this.lastCpFsyncDuration.value(fsyncDuration);
            this.lastCpDuration.value(duration);
            this.lastCpTotalPages.value(totalPages);
            this.lastCpDataPages.value(dataPages);
            this.lastCpCowPages.value(cowPages);
            this.storageSize.value(storageSize);
            this.sparseStorageSize.value(sparseStorageSize);
            this.totalCheckpointTime.add(duration);
        }
    }

    public void onWalRecordLogged() {
        this.walLoggingRate.increment();
    }

    public void onWalBytesWritten(int size) {
        this.walWritingRate.add(size);
    }

    public void onFsync(long nanoTime) {
        long microseconds = nanoTime / 1000L;
        this.walFsyncTimeDuration.add(microseconds);
        this.walFsyncTimeNum.increment();
    }

    public void onBuffPollSpin(int num) {
        this.walBuffPollSpinsNum.add(num);
    }

    private void resetRates() {
        this.walLoggingRate.reset(this.rateTimeInterval, this.subInts);
        this.walWritingRate.reset(this.rateTimeInterval, this.subInts);
        this.walBuffPollSpinsNum.reset(this.rateTimeInterval, this.subInts);
        this.walFsyncTimeDuration.reset(this.rateTimeInterval, this.subInts);
        this.walFsyncTimeNum.reset(this.rateTimeInterval, this.subInts);
    }
}

