/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import org.apache.ignite.DataRegionMetrics;

public class DataRegionMetricsSnapshot
implements DataRegionMetrics {
    private String name;
    private long totalAllocatedPages;
    private long totalUsedPages;
    private long totalAllocatedSize;
    private float allocationRate;
    private float evictionRate;
    private float largeEntriesPagesPercentage;
    private float pagesFillFactor;
    private long dirtyPages;
    private float pageReplaceRate;
    private float pageReplaceAge;
    private long physicalMemoryPages;
    private long physicalMemorySize;
    private long usedCheckpointBufferPages;
    private long usedCheckpointBufferSize;
    private long checkpointBufferSize;
    private int pageSize;
    private long readPages;
    private long writtenPages;
    private long replacedPage;
    private long offHeapSize;
    private long offHeapUsedSize;

    public DataRegionMetricsSnapshot(DataRegionMetrics metrics) {
        this.name = metrics.getName();
        this.totalAllocatedPages = metrics.getTotalAllocatedPages();
        this.totalUsedPages = metrics.getTotalUsedPages();
        this.totalAllocatedSize = metrics.getTotalAllocatedSize();
        this.allocationRate = metrics.getAllocationRate();
        this.evictionRate = metrics.getEvictionRate();
        this.largeEntriesPagesPercentage = metrics.getLargeEntriesPagesPercentage();
        this.pagesFillFactor = metrics.getPagesFillFactor();
        this.dirtyPages = metrics.getDirtyPages();
        this.pageReplaceRate = metrics.getPagesReplaceRate();
        this.pageReplaceAge = metrics.getPagesReplaceAge();
        this.physicalMemoryPages = metrics.getPhysicalMemoryPages();
        this.physicalMemorySize = metrics.getPhysicalMemorySize();
        this.usedCheckpointBufferPages = metrics.getUsedCheckpointBufferPages();
        this.usedCheckpointBufferSize = metrics.getUsedCheckpointBufferSize();
        this.checkpointBufferSize = metrics.getCheckpointBufferSize();
        this.pageSize = metrics.getPageSize();
        this.readPages = metrics.getPagesRead();
        this.writtenPages = metrics.getPagesWritten();
        this.replacedPage = metrics.getPagesReplaced();
        this.offHeapSize = metrics.getOffHeapSize();
        this.offHeapUsedSize = metrics.getOffheapUsedSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages;
    }

    @Override
    public long getTotalUsedPages() {
        return this.totalUsedPages;
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.totalAllocatedSize;
    }

    @Override
    public float getAllocationRate() {
        return this.allocationRate;
    }

    @Override
    public float getEvictionRate() {
        return this.evictionRate;
    }

    @Override
    public float getLargeEntriesPagesPercentage() {
        return this.largeEntriesPagesPercentage;
    }

    @Override
    public float getPagesFillFactor() {
        return this.pagesFillFactor;
    }

    @Override
    public long getDirtyPages() {
        return this.dirtyPages;
    }

    @Override
    public float getPagesReplaceRate() {
        return this.pageReplaceRate;
    }

    @Override
    public float getPagesReplaceAge() {
        return this.pageReplaceAge;
    }

    @Override
    public long getPhysicalMemoryPages() {
        return this.physicalMemoryPages;
    }

    @Override
    public long getPhysicalMemorySize() {
        return this.physicalMemorySize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        return this.usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        return this.checkpointBufferSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getPagesRead() {
        return this.readPages;
    }

    @Override
    public long getPagesWritten() {
        return this.writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        return this.replacedPage;
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        return this.offHeapUsedSize;
    }
}

