/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.EvictionContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionsEvictManager
extends GridCacheSharedManagerAdapter {
    private static final int DEFAULT_SHOW_EVICTION_PROGRESS_FREQ_MS = 120000;
    private static final String SHOW_EVICTION_PROGRESS_FREQ = "SHOW_EVICTION_PROGRESS_FREQ";
    private static final byte EVICT_POOL_PLC = 2;
    private final long evictionProgressFreqMs = IgniteSystemProperties.getLong("SHOW_EVICTION_PROGRESS_FREQ", 120000L);
    private final int confPermits = IgniteSystemProperties.getInteger("IGNITE_EVICTION_PERMITS", -1);
    private long lastShowProgressTimeNanos = System.nanoTime() - U.millisToNanos(this.evictionProgressFreqMs);
    private final Map<Integer, GroupEvictionContext> evictionGroupsMap = new ConcurrentHashMap<Integer, GroupEvictionContext>();
    private final Map<Integer, Map<Integer, EvictReason>> logEvictPartByGrps = new HashMap<Integer, Map<Integer, EvictReason>>();
    private volatile boolean stop;
    private final EvictionContext sharedEvictionCtx = () -> this.stop;
    private volatile int threads;
    private volatile int permits;
    volatile BucketQueue evictionQueue;
    private final Object mux = new Object();

    public void onCacheGroupStopped(CacheGroupContext grp) {
        GroupEvictionContext grpEvictionCtx = this.evictionGroupsMap.remove(grp.groupId());
        if (grpEvictionCtx != null) {
            grpEvictionCtx.stop();
            grpEvictionCtx.awaitFinishAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictPartitionAsync(CacheGroupContext grp, GridDhtLocalPartition part, EvictReason reason) {
        int bucket;
        assert (Objects.nonNull(grp));
        assert (Objects.nonNull(part));
        assert (Objects.nonNull((Object)reason));
        int grpId = grp.groupId();
        GroupEvictionContext grpEvictionCtx = this.evictionGroupsMap.computeIfAbsent(grpId, k -> new GroupEvictionContext(grp));
        if (grpEvictionCtx.shouldStop()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            int partId = part.id();
            if (!grpEvictionCtx.partIds.add(partId)) {
                return;
            }
            bucket = this.evictionQueue.offer(new PartitionEvictionTask(part, grpEvictionCtx, reason));
            this.logEvictPartByGrps.computeIfAbsent(grpId, i -> new HashMap()).put(partId, reason);
        }
        grpEvictionCtx.totalTasks.incrementAndGet();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition has been scheduled for eviction [grp=" + grp.cacheOrGroupName() + ", p=" + part.id() + ", state=" + (Object)((Object)part.state()) + "]");
        }
        this.scheduleNextPartitionEviction(bucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextPartitionEviction(int bucket) {
        if (this.sharedEvictionCtx.shouldStop()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.permits > 0) {
                if (this.evictionQueue.isEmpty()) {
                    return;
                }
                while (this.permits >= 0) {
                    PartitionEvictionTask evictionTask = this.evictionQueue.poll(bucket);
                    if (evictionTask == null) {
                        while (!this.evictionQueue.isEmpty() && (evictionTask = this.evictionQueue.pollAny()) == null) {
                        }
                        if (evictionTask == null) {
                            return;
                        }
                    }
                    this.showProgress();
                    GroupEvictionContext grpEvictionCtx = evictionTask.grpEvictionCtx;
                    if (grpEvictionCtx.shouldStop()) continue;
                    --this.permits;
                    grpEvictionCtx.taskScheduled(evictionTask);
                    evictionTask.finishFut.listen(f -> {
                        Object object = this.mux;
                        synchronized (object) {
                            ++this.permits;
                        }
                        this.scheduleNextPartitionEviction(bucket);
                    });
                    this.cctx.kernalContext().closure().runLocalSafe((Runnable)evictionTask, (byte)2);
                }
            }
        }
    }

    private void showProgress() {
        if (U.millisSinceNanos(this.lastShowProgressTimeNanos) >= this.evictionProgressFreqMs) {
            int size = this.evictionQueue.size() + 1;
            if (this.log.isInfoEnabled()) {
                this.log.info("Eviction in progress [permits=" + this.permits + ", threads=" + this.threads + ", groups=" + this.evictionGroupsMap.keySet().size() + ", remainingPartsToEvict=" + size + "]");
                this.evictionGroupsMap.values().forEach(rec$ -> ((GroupEvictionContext)rec$).showProgress());
                if (!this.logEvictPartByGrps.isEmpty()) {
                    StringJoiner evictPartJoiner = new StringJoiner(", ");
                    this.logEvictPartByGrps.forEach((grpId, evictParts) -> {
                        CacheGroupContext grpCtx = this.cctx.cache().cacheGroup((int)grpId);
                        String grpName = Objects.nonNull(grpCtx) ? grpCtx.cacheOrGroupName() : null;
                        String partByReasonStr = this.partByReasonStr((Map<Integer, EvictReason>)evictParts);
                        evictPartJoiner.add("[grpId=" + grpId + ", grpName=" + grpName + ", " + partByReasonStr + ']');
                    });
                    this.log.info("Partitions have been scheduled for eviction: " + evictPartJoiner);
                    this.logEvictPartByGrps.clear();
                }
            }
            this.lastShowProgressTimeNanos = System.nanoTime();
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        if (this.confPermits == -1) {
            int sysPoolSize = this.cctx.kernalContext().config().getSystemThreadPoolSize();
            this.threads = this.permits = sysPoolSize / 4;
        } else {
            this.threads = this.permits = this.confPermits;
        }
        if (this.threads == 0) {
            this.permits = 1;
            this.threads = 1;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Evict partition permits=" + this.permits);
        }
        this.evictionQueue = new BucketQueue(this.threads);
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.stop = true;
        Collection<GroupEvictionContext> evictionGrps = this.evictionGroupsMap.values();
        evictionGrps.forEach(rec$ -> ((GroupEvictionContext)rec$).stop());
        evictionGrps.forEach(rec$ -> ((GroupEvictionContext)rec$).awaitFinishAll());
    }

    private String partByReasonStr(Map<Integer, EvictReason> evictParts) {
        assert (Objects.nonNull(evictParts));
        EnumMap<EvictReason, Collection> partByReason = new EnumMap<EvictReason, Collection>(EvictReason.class);
        for (Map.Entry<Integer, EvictReason> entry : evictParts.entrySet()) {
            partByReason.computeIfAbsent(entry.getValue(), b -> new ArrayList()).add(entry.getKey());
        }
        StringJoiner joiner = new StringJoiner(", ");
        partByReason.forEach((reason, partIds) -> joiner.add(reason.toString() + '=' + S.compact(partIds)));
        return joiner.toString();
    }

    public void awaitFinishAll() {
        this.evictionGroupsMap.values().forEach(rec$ -> ((GroupEvictionContext)rec$).awaitFinishAll());
    }

    static enum EvictReason {
        EVICTION,
        CLEARING;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    class BucketQueue {
        private final long[] bucketSizes;
        final Queue<PartitionEvictionTask>[] buckets;
        private static final byte QUEUE_TYPE = 1;

        BucketQueue(int buckets) {
            this.buckets = new Queue[buckets];
            for (int i = 0; i < buckets; ++i) {
                this.buckets[i] = this.createEvictPartitionQueue();
            }
            this.bucketSizes = new long[buckets];
        }

        PartitionEvictionTask poll(int bucket) {
            PartitionEvictionTask task = this.buckets[bucket].poll();
            if (task != null) {
                int n = bucket;
                this.bucketSizes[n] = this.bucketSizes[n] - task.size;
            }
            return task;
        }

        PartitionEvictionTask pollAny() {
            for (int bucket = 0; bucket < this.bucketSizes.length; ++bucket) {
                if (this.buckets[bucket].isEmpty()) continue;
                return this.poll(bucket);
            }
            return null;
        }

        int offer(PartitionEvictionTask task) {
            int bucket = this.calculateBucket();
            this.buckets[bucket].offer(task);
            int n = bucket;
            this.bucketSizes[n] = this.bucketSizes[n] + task.size;
            return bucket;
        }

        boolean isEmpty() {
            return this.size() == 0;
        }

        int size() {
            int size = 0;
            for (Queue<PartitionEvictionTask> queue : this.buckets) {
                size += queue.size();
            }
            return size;
        }

        private int calculateBucket() {
            int min;
            for (int bucket = min = 0; bucket < this.bucketSizes.length; ++bucket) {
                if (this.bucketSizes[min] <= this.bucketSizes[bucket]) continue;
                min = bucket;
            }
            return min;
        }

        private Queue<PartitionEvictionTask> createEvictPartitionQueue() {
            switch (1) {
                case 1: {
                    return new PriorityBlockingQueue<PartitionEvictionTask>(1000, Comparator.comparingLong(p -> ((PartitionEvictionTask)p).part.fullSize()));
                }
            }
            return new LinkedBlockingQueue<PartitionEvictionTask>();
        }
    }

    class PartitionEvictionTask
    implements Runnable {
        private final GridDhtLocalPartition part;
        private final long size;
        private final EvictReason reason;
        private final GroupEvictionContext grpEvictionCtx;
        private final GridFutureAdapter<?> finishFut = new GridFutureAdapter();

        private PartitionEvictionTask(GridDhtLocalPartition part, GroupEvictionContext grpEvictionCtx, EvictReason reason) {
            this.part = part;
            this.grpEvictionCtx = grpEvictionCtx;
            this.reason = reason;
            this.size = part.fullSize();
        }

        @Override
        public void run() {
            if (this.grpEvictionCtx.shouldStop()) {
                this.finishFut.onDone();
                return;
            }
            try {
                boolean success = this.part.tryClear(this.grpEvictionCtx);
                if (success && this.part.state() == GridDhtPartitionState.EVICTED && this.part.markForDestroy()) {
                    this.part.destroy();
                }
                this.finishFut.onDone();
                if (!success) {
                    PartitionsEvictManager.this.evictPartitionAsync(this.grpEvictionCtx.grp, this.part, this.reason);
                }
            }
            catch (Throwable ex) {
                this.finishFut.onDone(ex);
                if (PartitionsEvictManager.this.cctx.kernalContext().isStopping()) {
                    LT.warn(PartitionsEvictManager.this.log, ex, "Partition eviction failed (current node is stopping) [grp=" + this.grpEvictionCtx.grp.cacheOrGroupName() + ", readyVer=" + this.grpEvictionCtx.grp.topology().readyTopologyVersion() + ']', false, true);
                }
                LT.error(PartitionsEvictManager.this.log, ex, "Partition eviction failed, this can cause grid hang.");
                PartitionsEvictManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, ex));
            }
        }
    }

    private class GroupEvictionContext
    implements EvictionContext {
        private final CacheGroupContext grp;
        private final Set<Integer> partIds = new HashSet<Integer>();
        private final Map<Integer, IgniteInternalFuture<?>> partsEvictFutures = new ConcurrentHashMap();
        private volatile boolean stop;
        private AtomicInteger totalTasks = new AtomicInteger();
        private int taskInProgress;

        private GroupEvictionContext(CacheGroupContext grp) {
            this.grp = grp;
        }

        @Override
        public boolean shouldStop() {
            return this.stop || PartitionsEvictManager.this.sharedEvictionCtx.shouldStop();
        }

        private synchronized void taskScheduled(PartitionEvictionTask task) {
            if (this.shouldStop()) {
                return;
            }
            ++this.taskInProgress;
            GridFutureAdapter fut = task.finishFut;
            int partId = task.part.id();
            this.partIds.remove(partId);
            this.partsEvictFutures.put(partId, fut);
            fut.listen(f -> {
                GroupEvictionContext groupEvictionContext = this;
                synchronized (groupEvictionContext) {
                    --this.taskInProgress;
                    this.partsEvictFutures.remove(partId, f);
                    if (this.totalTasks.decrementAndGet() == 0) {
                        PartitionsEvictManager.this.evictionGroupsMap.remove(this.grp.groupId());
                    }
                }
            });
        }

        private void stop() {
            this.stop = true;
        }

        private void awaitFinishAll() {
            this.partsEvictFutures.forEach(this::awaitFinish);
            PartitionsEvictManager.this.evictionGroupsMap.remove(this.grp.groupId());
        }

        private void awaitFinish(Integer part, IgniteInternalFuture<?> fut) {
            block3: {
                try {
                    if (PartitionsEvictManager.this.log.isInfoEnabled()) {
                        PartitionsEvictManager.this.log.info("Await partition evict, grpName=" + this.grp.cacheOrGroupName() + ", grpId=" + this.grp.groupId() + ", partId=" + part);
                    }
                    fut.get();
                }
                catch (IgniteCheckedException e) {
                    if (!PartitionsEvictManager.this.log.isDebugEnabled()) break block3;
                    PartitionsEvictManager.this.log.warning("Failed to await partition eviction during stopping.", e);
                }
            }
        }

        private void showProgress() {
            if (PartitionsEvictManager.this.log.isInfoEnabled()) {
                PartitionsEvictManager.this.log.info("Group eviction in progress [grpName=" + this.grp.cacheOrGroupName() + ", grpId=" + this.grp.groupId() + ", remainingPartsToEvict=" + (this.totalTasks.get() - this.taskInProgress) + ", partsEvictInProgress=" + this.taskInProgress + ", totalParts=" + this.grp.topology().localPartitions().size() + "]");
            }
        }
    }
}

