/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgniteDhtDemandedPartitionsMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    private CachePartitionPartialCountersMap historical;
    @GridToStringInclude
    private Set<Integer> full;

    public void addHistorical(int partId, long from, long to, int partCnt) {
        assert (!this.hasFull(partId));
        if (this.historical == null) {
            this.historical = new CachePartitionPartialCountersMap(partCnt);
        }
        this.historical.add(partId, from, to);
    }

    public void addFull(int partId) {
        assert (!this.hasHistorical(partId));
        if (this.full == null) {
            this.full = new HashSet<Integer>();
        }
        this.full.add(partId);
    }

    public boolean remove(int partId) {
        assert (!this.hasFull(partId) || !this.hasHistorical(partId));
        if (this.full != null && this.full.remove(partId)) {
            return true;
        }
        return this.historical != null && this.historical.remove(partId);
    }

    public boolean hasPartition(int partId) {
        return this.hasHistorical(partId) || this.hasFull(partId);
    }

    public boolean hasHistorical() {
        return this.historical != null && !this.historical.isEmpty();
    }

    public boolean hasHistorical(int partId) {
        return this.historical != null && this.historical.contains(partId);
    }

    public boolean hasFull() {
        return this.full != null && !this.full.isEmpty();
    }

    public boolean hasFull(int partId) {
        return this.full != null && this.full.contains(partId);
    }

    public boolean isEmpty() {
        return !this.hasFull() && !this.hasHistorical();
    }

    public int size() {
        int histSize = this.historical != null ? this.historical.size() : 0;
        int fullSize = this.full != null ? this.full.size() : 0;
        return histSize + fullSize;
    }

    public CachePartitionPartialCountersMap historicalMap() {
        if (this.historical == null) {
            return CachePartitionPartialCountersMap.EMPTY;
        }
        return this.historical;
    }

    public Set<Integer> fullSet() {
        if (this.full == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.full);
    }

    public Set<Integer> historicalSet() {
        if (this.historical == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> historical = new HashSet<Integer>(this.historicalMap().size());
        for (int i = 0; i < this.historicalMap().size(); ++i) {
            int p = this.historicalMap().partitionAt(i);
            historical.add(p);
        }
        return historical;
    }

    public String toString() {
        return S.toString(IgniteDhtDemandedPartitionsMap.class, this);
    }
}

