/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteFuture;

public class GridCacheSharedManagerAdapter<K, V>
implements GridCacheSharedManager<K, V> {
    private static final String DIAGNOSTIC_LOG_CATEGORY = "org.apache.ignite.internal.diagnostic";
    protected GridCacheSharedContext<K, V> cctx;
    protected IgniteLogger log;
    protected IgniteLogger diagnosticLog;
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final AtomicBoolean stop = new AtomicBoolean(false);

    @Override
    public final void start(GridCacheSharedContext<K, V> cctx) throws IgniteCheckedException {
        if (!this.starting.compareAndSet(false, true)) assert (false) : "Method start is called more than once for manager: " + this;
        assert (cctx != null);
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
        this.diagnosticLog = cctx.logger(DIAGNOSTIC_LOG_CATEGORY);
        this.start0();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    protected IgniteLogger log() {
        return this.log;
    }

    protected GridCacheSharedContext<K, V> context() {
        return this.cctx;
    }

    protected void start0() throws IgniteCheckedException {
    }

    @Override
    public final void onKernalStart(boolean active) {
        if (!this.starting.get()) {
            return;
        }
        this.onKernalStart0(active);
    }

    protected void onKernalStart0(boolean active) {
    }

    @Override
    public final void stop(boolean cancel) {
        if (!this.starting.get() || !this.stop.compareAndSet(false, true)) {
            return;
        }
        this.stop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    protected final boolean isStopping() {
        return this.stop.get();
    }

    protected void stop0(boolean cancel) {
    }

    @Override
    public final void onKernalStop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.onKernalStop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStopInfo());
        }
    }

    protected void onKernalStop0(boolean cancel) {
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
    }

    @Override
    public void onReconnected(boolean active) {
    }

    @Override
    public void printMemoryStats() {
    }

    protected String startInfo() {
        return "Cache manager started.";
    }

    protected String stopInfo() {
        return "Cache manager stopped.";
    }

    protected String kernalStartInfo() {
        return "Cache manager received onKernalStart() callback.";
    }

    protected String kernalStopInfo() {
        return "Cache manager received onKernalStop() callback.";
    }

    public String toString() {
        return S.toString(GridCacheSharedManagerAdapter.class, this);
    }
}

