/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.systemview.FiltrableSystemViewAdapter;
import org.apache.ignite.internal.managers.systemview.SystemViewAdapter;
import org.apache.ignite.internal.managers.systemview.SystemViewInnerCollectionsAdapter;
import org.apache.ignite.internal.managers.systemview.walker.StripedExecutorTaskViewWalker;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.systemview.ReadOnlySystemViewRegistry;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;
import org.apache.ignite.spi.systemview.view.StripedExecutorTaskView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSystemViewManager
extends GridManagerAdapter<SystemViewExporterSpi>
implements ReadOnlySystemViewRegistry {
    public static final String SYS_POOL_QUEUE_VIEW = MetricUtils.metricName("striped", "threadpool", "queue");
    public static final String SYS_POOL_QUEUE_VIEW_DESC = "Striped thread pool task queue";
    public static final String STREAM_POOL_QUEUE_VIEW = MetricUtils.metricName("datastream", "threadpool", "queue");
    public static final String STREAM_POOL_QUEUE_VIEW_DESC = "Datastream thread pool task queue";
    private final ConcurrentHashMap<String, SystemView<?>> systemViews = new ConcurrentHashMap();
    private final List<Consumer<SystemView<?>>> viewCreationLsnrs = new CopyOnWriteArrayList();

    public GridSystemViewManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getSystemViewExporterSpi());
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (SystemViewExporterSpi spi : (SystemViewExporterSpi[])this.getSpis()) {
            spi.setSystemViewRegistry(this);
        }
        this.startSpi();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
    }

    public void registerThreadPools(StripedExecutor stripedExecSvc, StripedExecutor dataStreamExecSvc) {
        this.ctx.systemView().registerInnerCollectionView(SYS_POOL_QUEUE_VIEW, SYS_POOL_QUEUE_VIEW_DESC, new StripedExecutorTaskViewWalker(), Arrays.asList(stripedExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
        this.ctx.systemView().registerInnerCollectionView(STREAM_POOL_QUEUE_VIEW, STREAM_POOL_QUEUE_VIEW_DESC, new StripedExecutorTaskViewWalker(), Arrays.asList(dataStreamExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
    }

    public <R> void registerView(SystemView<R> sysView) {
        this.registerView0(sysView.name(), sysView);
    }

    public <R, D> void registerView(String name, String desc, SystemViewRowAttributeWalker<R> walker, Collection<D> data, Function<D, R> rowFunc) {
        this.registerView0(name, new SystemViewAdapter<R, D>(name, desc, walker, data, rowFunc));
    }

    public <C, R, D> void registerInnerCollectionView(String name, String desc, SystemViewRowAttributeWalker<R> walker, Iterable<C> container, Function<C, Collection<D>> dataExtractor, BiFunction<C, D, R> rowFunc) {
        this.registerView0(name, new SystemViewInnerCollectionsAdapter<C, R, D>(name, desc, walker, container, dataExtractor, rowFunc));
    }

    public <C, R, D> void registerInnerArrayView(String name, String desc, SystemViewRowAttributeWalker<R> walker, Collection<C> container, Function<C, D[]> dataExtractor, BiFunction<C, D, R> rowFunc) {
        this.registerView0(name, new SystemViewInnerCollectionsAdapter<Object, R, D>(name, desc, walker, container, c -> Arrays.asList((Object[])dataExtractor.apply(c)), rowFunc));
    }

    public <R, D> void registerView(String name, String desc, SystemViewRowAttributeWalker<R> walker, Supplier<Collection<D>> dataSupplier, Function<D, R> rowFunc) {
        this.registerView0(name, new SystemViewAdapter<R, D>(name, desc, walker, dataSupplier, rowFunc));
    }

    public <R, D> void registerFiltrableView(String name, String desc, SystemViewRowAttributeWalker<R> walker, Function<Map<String, Object>, Iterable<D>> dataSupplier, Function<D, R> rowFunc) {
        this.registerView0(name, new FiltrableSystemViewAdapter<R, D>(name, desc, walker, dataSupplier, rowFunc));
    }

    private void registerView0(String name, SystemView sysView) {
        this.systemViews.put(name, sysView);
        IgniteUtils.notifyListeners(sysView, this.viewCreationLsnrs, this.log);
    }

    @Nullable
    public <R> SystemView<R> view(String name) {
        return this.systemViews.get(name);
    }

    @Override
    public void addSystemViewCreationListener(Consumer<SystemView<?>> lsnr) {
        this.viewCreationLsnrs.add(lsnr);
    }

    @Override
    @NotNull
    public Iterator<SystemView<?>> iterator() {
        return this.systemViews.values().iterator();
    }
}

