/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommand;
import org.apache.ignite.internal.visor.encryption.VisorChangeMasterKeyTask;
import org.apache.ignite.internal.visor.encryption.VisorGetMasterKeyNameTask;

public class EncryptionCommand
implements Command<Object> {
    EncryptionSubcommand cmd;
    String taskName;
    Object taskArgs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            String res = (String)TaskExecutor.executeTaskByNameOnNode(client, this.taskName, this.taskArgs, null, clientCfg);
            logger.info(res);
            String string = res;
            return string;
        }
        catch (Throwable e) {
            logger.severe("Failed to perform operation.");
            logger.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public String confirmationPrompt() {
        if (EncryptionSubcommand.CHANGE_MASTER_KEY == this.cmd) {
            return "Warning: the command will change the master key. Cache start and node join during the key change process is prohibited and will be rejected.";
        }
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        EncryptionSubcommand cmd = EncryptionSubcommand.of(argIter.nextArg("Expected encryption action."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct encryption action.");
        }
        switch (cmd) {
            case GET_MASTER_KEY_NAME: {
                this.taskName = VisorGetMasterKeyNameTask.class.getName();
                this.taskArgs = null;
                break;
            }
            case CHANGE_MASTER_KEY: {
                String masterKeyName = argIter.nextArg("Expected master key name.");
                this.taskName = VisorChangeMasterKeyTask.class.getName();
                this.taskArgs = masterKeyName;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encryption subcommand: " + (Object)((Object)cmd));
            }
        }
        this.cmd = cmd;
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Print the current master key name:", CommandList.ENCRYPTION, EncryptionSubcommand.GET_MASTER_KEY_NAME.toString());
        Command.usage(logger, "Change the master key:", CommandList.ENCRYPTION, EncryptionSubcommand.CHANGE_MASTER_KEY.toString(), "newMasterKeyName");
    }

    @Override
    public String name() {
        return CommandList.ENCRYPTION.toCommandName();
    }
}

