/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.cache.CacheContention;
import org.apache.ignite.internal.commandline.cache.CacheDistribution;
import org.apache.ignite.internal.commandline.cache.CacheValidateIndexes;
import org.apache.ignite.internal.commandline.cache.CacheViewer;
import org.apache.ignite.internal.commandline.cache.CheckIndexInlineSizes;
import org.apache.ignite.internal.commandline.cache.FindAndDeleteGarbage;
import org.apache.ignite.internal.commandline.cache.IdleVerify;
import org.apache.ignite.internal.commandline.cache.ResetLostPartitions;
import org.jetbrains.annotations.Nullable;

public enum CacheCommandList {
    HELP("help", null),
    IDLE_VERIFY("idle_verify", new IdleVerify()),
    LIST("list", new CacheViewer()),
    VALIDATE_INDEXES("validate_indexes", new CacheValidateIndexes()),
    CHECK_INDEX_INLINE_SIZES("check_index_inline_sizes", new CheckIndexInlineSizes()),
    CONTENTION("contention", new CacheContention()),
    DISTRIBUTION("distribution", new CacheDistribution()),
    RESET_LOST_PARTITIONS("reset_lost_partitions", new ResetLostPartitions()),
    FIND_AND_DELETE_GARBAGE("find_garbage", new FindAndDeleteGarbage());

    private static final CacheCommandList[] VALS;
    private final String name;
    private final Command command;

    private CacheCommandList(String name, Command command) {
        this.name = name;
        this.command = command;
    }

    public static CacheCommandList of(String text) {
        for (CacheCommandList cmd : CacheCommandList.values()) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    public Command subcommand() {
        return this.command;
    }

    @Nullable
    public static CacheCommandList fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALS = CacheCommandList.values();
    }
}

