/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.configuration.VisorTracingConfigurationTask;
import org.apache.ignite.internal.commandline.configuration.VisorTracingConfigurationTaskArg;
import org.apache.ignite.internal.commandline.configuration.VisorTracingConfigurationTaskResult;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationArguments;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationCommandArg;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationSubcommand;
import org.apache.ignite.spi.tracing.Scope;

public class TracingConfigurationCommand
implements Command<TracingConfigurationArguments> {
    private TracingConfigurationArguments args;

    @Override
    public void printUsage(Logger log) {
        if (!this.experimentalEnabled()) {
            return;
        }
        Command.usage(log, "Print tracing configuration: ", CommandList.TRACING_CONFIGURATION, new String[0]);
        Command.usage(log, "Print tracing configuration: ", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.GET_ALL.text(), CommandLogger.optional(TracingConfigurationCommandArg.SCOPE.argName(), CommandLogger.join("|", (Object[])Scope.values())));
        Command.usage(log, "Print specific tracing configuration based on specified " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + ": ", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.GET.text(), CommandLogger.grouped(TracingConfigurationCommandArg.SCOPE.argName(), CommandLogger.join("|", (Object[])Scope.values())), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.argName()));
        Command.usage(log, "Reset all specific tracing configuration the to default. If " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified, then remove all label specific configuration for the given scope and reset given scope specific configuration to the default, if " + TracingConfigurationCommandArg.SCOPE.argName() + " is skipped then reset all tracing configurations to the default. Print tracing configuration.", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.RESET_ALL.text(), CommandLogger.optional(TracingConfigurationCommandArg.SCOPE.argName(), CommandLogger.join("|", (Object[])Scope.values())));
        Command.usage(log, "Reset specific tracing configuration to the default. If both " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + " are specified then remove given configuration, if only " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified then reset given configuration to the default. Print reseted configuration.", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.RESET.text(), CommandLogger.grouped(TracingConfigurationCommandArg.SCOPE.argName(), CommandLogger.join("|", (Object[])Scope.values())), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.argName()));
        Command.usage(log, "Set new tracing configuration. If both " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + " are specified then add or override label specific configuration, if only " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified, then override scope specific configuration. Print applied configuration.", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.SET.text(), CommandLogger.grouped(TracingConfigurationCommandArg.SCOPE.argName(), CommandLogger.join("|", (Object[])Scope.values()), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.argName()), CommandLogger.optional(TracingConfigurationCommandArg.SAMPLING_RATE.argName(), "Decimal value between 0 and 1, where 0 means never and 1 means always. More or less reflects the probability of sampling specific trace."), CommandLogger.optional(TracingConfigurationCommandArg.INCLUDED_SCOPES.argName(), "Set of scopes with comma as separator ", CommandLogger.join("|", (Object[])Scope.values()))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        if (!this.experimentalEnabled()) {
            log.warning(String.format("For use experimental command add %s=true to JVM_OPTS in %s", "IGNITE_ENABLE_EXPERIMENTAL_COMMAND", "control.(sh|bat)"));
            return null;
        }
        try (GridClient client = Command.startClient(clientCfg);){
            UUID crdId = client.compute().nodes(node -> !node.isClient()).stream().min(Comparator.comparingLong(GridClientNode::order)).map(GridClientNode::nodeId).orElse(null);
            VisorTracingConfigurationTaskResult res = (VisorTracingConfigurationTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorTracingConfigurationTask.class.getName(), this.toVisorArguments(this.args), crdId, clientCfg);
            this.printResult(res, log::info);
            VisorTracingConfigurationTaskResult visorTracingConfigurationTaskResult = res;
            return visorTracingConfigurationTaskResult;
        }
        catch (Throwable e) {
            log.severe("Failed to execute tracing-configuration command='" + this.args.command().text() + "'");
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.args = new TracingConfigurationArguments.Builder(TracingConfigurationSubcommand.GET_ALL).build();
            return;
        }
        TracingConfigurationSubcommand cmd = TracingConfigurationSubcommand.of(argIter.nextArg("Expected tracing configuration action."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct tracing configuration action.");
        }
        TracingConfigurationArguments.Builder tracingConfigurationArgs = new TracingConfigurationArguments.Builder(cmd);
        Scope scope = null;
        String lb = null;
        double samplingRate = 0.0;
        HashSet<Scope> includedScopes = new HashSet<Scope>();
        block17: while (argIter.hasNextSubArg()) {
            TracingConfigurationCommandArg arg = CommandArgUtils.of(argIter.nextArg(""), TracingConfigurationCommandArg.class);
            assert (arg != null);
            switch (arg) {
                case SCOPE: {
                    String peekedNextArg = argIter.peekNextArg();
                    if (TracingConfigurationCommandArg.args().contains(peekedNextArg)) break;
                    String strVal = argIter.nextArg("The scope should be specified. The following values can be used: " + Arrays.toString((Object[])Scope.values()) + '.');
                    try {
                        scope = Scope.valueOf(strVal);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid scope '" + strVal + "'. The following values can be used: " + Arrays.toString((Object[])Scope.values()) + '.');
                    }
                }
                case LABEL: {
                    lb = argIter.nextArg("The label should be specified.");
                    break;
                }
                case SAMPLING_RATE: {
                    String strVal = argIter.nextArg("The sampling rate should be specified. Decimal value between 0 and 1 should be used.");
                    try {
                        samplingRate = Double.parseDouble(strVal);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid sampling-rate '" + strVal + "'. Decimal value between 0 and 1 should be used.");
                    }
                    if (!(samplingRate < 0.0) && !(samplingRate > 1.0)) break;
                    throw new IllegalArgumentException("Invalid sampling-rate '" + strVal + "'. Decimal value between 0 and 1 should be used.");
                }
                case INCLUDED_SCOPES: {
                    Set<String> setStrVals = argIter.nextStringSet("At least one supported scope should be specified.");
                    for (String scopeStrVal : setStrVals) {
                        try {
                            includedScopes.add(Scope.valueOf(scopeStrVal));
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid supported scope '" + scopeStrVal + "'. The following values can be used: " + Arrays.toString((Object[])Scope.values()) + '.');
                        }
                    }
                    continue block17;
                }
            }
        }
        if (cmd != TracingConfigurationSubcommand.GET_ALL && cmd != TracingConfigurationSubcommand.RESET_ALL && scope == null) {
            throw new IllegalArgumentException("Scope attribute is missing. Following values can be used: " + Arrays.toString((Object[])Scope.values()) + '.');
        }
        switch (cmd) {
            case GET_ALL: 
            case RESET_ALL: {
                tracingConfigurationArgs.withScope(scope);
                break;
            }
            case RESET: 
            case GET: {
                tracingConfigurationArgs.withScope(scope).withLabel(lb);
                break;
            }
            case SET: {
                tracingConfigurationArgs.withScope(scope).withLabel(lb).withSamplingRate(samplingRate).withIncludedScopes(includedScopes);
                break;
            }
            default: {
                assert (false) : "Unexpected tracing configuration argument [arg= " + (Object)((Object)cmd) + ']';
                break;
            }
        }
        this.args = tracingConfigurationArgs.build();
    }

    @Override
    public TracingConfigurationArguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CommandList.TRACING_CONFIGURATION.toCommandName();
    }

    @Override
    public boolean experimental() {
        return true;
    }

    private void printResult(VisorTracingConfigurationTaskResult res, Consumer<String> printer) {
        res.print(printer);
    }

    private VisorTracingConfigurationTaskArg toVisorArguments(TracingConfigurationArguments args) {
        return new VisorTracingConfigurationTaskArg(args.command().visorBaselineOperation(), args.scope(), args.label(), args.samplingRate(), args.includedScopes());
    }
}

