/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

class ClientFutureImpl<R>
implements Future<R> {
    private final GridFutureAdapter<R> delegate;

    ClientFutureImpl(GridFutureAdapter<R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R get() throws ExecutionException, CancellationException, InterruptedException {
        try {
            return this.delegate.get();
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IgniteFutureCancelledCheckedException e) {
            throw new CancellationException(e.getMessage());
        }
        catch (Exception e) {
            throw new ExecutionException(ClientFutureImpl.unwrapException(e));
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, CancellationException, InterruptedException {
        try {
            return this.delegate.get(timeout, unit);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IgniteFutureTimeoutCheckedException e) {
            throw new TimeoutException(e.getMessage());
        }
        catch (IgniteFutureCancelledCheckedException e) {
            throw new CancellationException(e.getMessage());
        }
        catch (Exception e) {
            throw new ExecutionException(ClientFutureImpl.unwrapException(e));
        }
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) throws ClientException {
        try {
            return mayInterruptIfRunning ? this.delegate.cancel() : this.delegate.onCancelled();
        }
        catch (IgniteCheckedException e) {
            throw ClientFutureImpl.unwrapException(e);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    private static ClientException unwrapException(Exception e) {
        Exception e0;
        Throwable throwable = e0 = e instanceof IgniteCheckedException && e.getCause() != null ? e.getCause() : e;
        if (e0 instanceof ClientException) {
            return (ClientException)e0;
        }
        return new ClientException(e0);
    }
}

