/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.console.configuration;

import java.util.Set;

/**
 * Service class with list of generated by configurator, known deprecated, and excluded from configurator fields.
 */
@SuppressWarnings("AssignmentOrReturnOfFieldWithMutableType")
public class MetadataInfo {
    /** List of generated fields. */
    private final Set<String> generatedFields;

    /** List of deprecated fields. */
    private final Set<String> deprecatedFields;

    /** List of excluded fields. */
    private final Set<String> excludedFields;

    /**
     * Constructor.
     *
     * @param generatedFields List of generated fields.
     * @param deprecatedFields List of deprecated fields.
     * @param excludedFields List of excluded fields.
     */
    public MetadataInfo(Set<String> generatedFields, Set<String> deprecatedFields, Set<String> excludedFields) {
        this.generatedFields = generatedFields;
        this.deprecatedFields = deprecatedFields;
        this.excludedFields = excludedFields;
    }

    /**
     * @return List of generated fields.
     */
    public Set<String> getGeneratedFields() {
        return generatedFields;
    }

    /**
     * @return List of deprecated fields.
     */
    public Set<String> getDeprecatedFields() {
        return deprecatedFields;
    }

    /**
     * @return List of excluded fields.
     */
    public Set<String> getExcludedFields() {
        return excludedFields;
    }
}
