/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.UUID;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.ComputeJobView.ComputeJobState;
import org.apache.ignite.spi.systemview.view.ComputeJobView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link ComputeJobView} attributes walker.
 * 
 * @see ComputeJobView
 */
public class ComputeJobViewWalker implements SystemViewRowAttributeWalker<ComputeJobView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "id", IgniteUuid.class);
        v.accept(1, "sessionId", IgniteUuid.class);
        v.accept(2, "originNodeId", UUID.class);
        v.accept(3, "taskName", String.class);
        v.accept(4, "taskClassName", String.class);
        v.accept(5, "affinityCacheIds", String.class);
        v.accept(6, "affinityPartitionId", int.class);
        v.accept(7, "createTime", long.class);
        v.accept(8, "startTime", long.class);
        v.accept(9, "finishTime", long.class);
        v.accept(10, "executorName", String.class);
        v.accept(11, "isFinishing", boolean.class);
        v.accept(12, "isInternal", boolean.class);
        v.accept(13, "isStarted", boolean.class);
        v.accept(14, "isTimedOut", boolean.class);
        v.accept(15, "state", ComputeJobState.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(ComputeJobView row, AttributeWithValueVisitor v) {
        v.accept(0, "id", IgniteUuid.class, row.id());
        v.accept(1, "sessionId", IgniteUuid.class, row.sessionId());
        v.accept(2, "originNodeId", UUID.class, row.originNodeId());
        v.accept(3, "taskName", String.class, row.taskName());
        v.accept(4, "taskClassName", String.class, row.taskClassName());
        v.accept(5, "affinityCacheIds", String.class, row.affinityCacheIds());
        v.acceptInt(6, "affinityPartitionId", row.affinityPartitionId());
        v.acceptLong(7, "createTime", row.createTime());
        v.acceptLong(8, "startTime", row.startTime());
        v.acceptLong(9, "finishTime", row.finishTime());
        v.accept(10, "executorName", String.class, row.executorName());
        v.acceptBoolean(11, "isFinishing", row.isFinishing());
        v.acceptBoolean(12, "isInternal", row.isInternal());
        v.acceptBoolean(13, "isStarted", row.isStarted());
        v.acceptBoolean(14, "isTimedOut", row.isTimedOut());
        v.accept(15, "state", ComputeJobState.class, row.state());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 16;
    }
}
