/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewNodeAttributes
extends SqlAbstractLocalSystemView {
    public SqlSystemViewNodeAttributes(GridKernalContext ctx) {
        super("NODE_ATTRIBUTES", "Node attributes", ctx, new String[]{"NODE_ID,NAME", "NAME"}, SqlSystemViewNodeAttributes.newColumn("NODE_ID", 20), SqlSystemViewNodeAttributes.newColumn("NAME"), SqlSystemViewNodeAttributes.newColumn("VALUE"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Collection<Object> nodes;
        SqlSystemViewColumnCondition nameCond;
        block7: {
            SqlSystemViewColumnCondition idCond = this.conditionForColumn("NODE_ID", first, last);
            nameCond = this.conditionForColumn("NAME", first, last);
            if (idCond.isEquality()) {
                try {
                    ClusterNode node2;
                    UUID nodeId = SqlSystemViewNodeAttributes.uuidFromValue(idCond.valueForEquality());
                    ClusterNode clusterNode = node2 = nodeId == null ? null : this.ctx.discovery().node(nodeId);
                    if (node2 != null) {
                        nodes = Collections.singleton(node2);
                        break block7;
                    }
                    nodes = Collections.emptySet();
                }
                catch (Exception e) {
                    nodes = Collections.emptySet();
                }
            } else {
                nodes = F.concat((boolean)false, (Collection)this.ctx.discovery().allNodes(), (Collection)this.ctx.discovery().daemonNodes());
            }
        }
        if (nameCond.isEquality()) {
            String attrName = nameCond.valueForEquality().getString();
            ArrayList<Row> rows = new ArrayList<Row>();
            for (ClusterNode clusterNode : nodes) {
                if (!clusterNode.attributes().containsKey(attrName)) continue;
                rows.add(this.createRow(ses, clusterNode.id(), attrName, clusterNode.attribute(attrName)));
            }
            return rows.iterator();
        }
        return F.concat((Iterator)F.iterator(nodes, (IgniteClosure & Serializable)node -> F.iterator(node.attributes().entrySet(), (IgniteClosure & Serializable)attr -> this.createRow(ses, node.id(), attr.getKey(), attr.getValue()), (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]).iterator(), (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]));
    }
}

