/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc.mvcc;

import java.util.Map;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.jdbc.DisjointRangeGenerator;
import org.apache.ignite.yardstick.jdbc.mvcc.AbstractDistributedMvccBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class MvccProcessorBenchmark
extends AbstractDistributedMvccBenchmark {
    private DisjointRangeGenerator locIdGen;
    private int idOffset;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        int locIdRangeWidth = this.args.range() / this.driversNodesCnt;
        this.locIdGen = new DisjointRangeGenerator(cfg.threads(), locIdRangeWidth, this.args.sqlRange());
        this.idOffset = locIdRangeWidth * this.memberId;
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long locStart = this.locIdGen.nextRangeStartId();
        long start = (long)this.idOffset + locStart;
        long end = (long)this.idOffset + this.locIdGen.endRangeId(locStart);
        this.execute(new SqlFieldsQuery("UPDATE test_long SET val = (val + 1) WHERE id BETWEEN ? AND ?").setArgs(new Object[]{start, end}));
        return true;
    }
}

