/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.api.r.JVMObjectId;
import org.apache.spark.api.r.JVMObjectTracker;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SerDe$ {
    public static final SerDe$ MODULE$;
    public Function2<DataInputStream, Object, Object> org$apache$spark$api$r$SerDe$$sqlReadObject;
    private Function2<DataOutputStream, Object, Object> sqlWriteObject;

    static {
        new SerDe$();
    }

    public SerDe$ setSQLReadObject(Function2<DataInputStream, Object, Object> value2) {
        this.org$apache$spark$api$r$SerDe$$sqlReadObject = value2;
        return this;
    }

    public SerDe$ setSQLWriteObject(Function2<DataOutputStream, Object, Object> value2) {
        this.sqlWriteObject = value2;
        return this;
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType, jvmObjectTracker);
    }

    public Object readTypedObject(DataInputStream dis, char dataType, JVMObjectTracker jvmObjectTracker) {
        Object object;
        char c = dataType;
        switch (c) {
            default: {
                if (this.org$apache$spark$api$r$SerDe$$sqlReadObject == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)dataType)})));
                }
                Object obj = this.org$apache$spark$api$r$SerDe$$sqlReadObject.apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
                if (obj == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)dataType)})));
                }
                object = obj;
                break;
            }
            case 'j': {
                object = jvmObjectTracker.apply(new JVMObjectId(this.readString(dis)));
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 'l': {
                object = this.readList(dis, jvmObjectTracker);
                break;
            }
            case 'a': {
                object = this.readArray(dis, jvmObjectTracker);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis, jvmObjectTracker);
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'b': {
                object = new Boolean(this.readBoolean(dis));
                break;
            }
            case 'd': {
                object = new Double(this.readDouble(dis));
                break;
            }
            case 'i': {
                object = new Integer(this.readInt(dis));
                break;
            }
            case 'n': {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        BoxedUnit bytesRead = BoxedUnit.UNIT;
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        Predef$.MODULE$.assert(bytes[len - 1] == 0);
        String str = new String((byte[])Predef$.MODULE$.byteArrayOps(bytes).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        return in.readInt() != 0;
    }

    public Date readDate(DataInputStream in) {
        Date date;
        try {
            String inStr;
            String string = inStr = this.readString(in);
            String string2 = "NA";
            date = !(string != null ? !string.equals(string2) : string2 != null) ? null : Date.valueOf(inStr);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            date = null;
        }
        return date;
    }

    public Timestamp readTime(DataInputStream in) {
        Timestamp timestamp;
        try {
            double seconds = in.readDouble();
            if (Double.isNaN(seconds)) {
                timestamp = null;
            } else {
                long sec = (long)Math.floor(seconds);
                Timestamp t = new Timestamp(sec * 1000L);
                t.setNanos((int)((seconds - (double)sec) * 1.0E9));
                timestamp = t;
            }
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            timestamp = null;
        }
        return timestamp;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$1;

            public final byte[] apply(int x$1) {
                return SerDe$.MODULE$.readBytes(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$2;

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int x$2) {
                return SerDe$.MODULE$.readInt(this.in$2);
            }
            {
                this.in$2 = in$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$3;

            public final double apply(int x$3) {
                return this.apply$mcDI$sp(x$3);
            }

            public double apply$mcDI$sp(int x$3) {
                return SerDe$.MODULE$.readDouble(this.in$3);
            }
            {
                this.in$3 = in$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$4;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return SerDe$.MODULE$.readBoolean(this.in$4);
            }
            {
                this.in$4 = in$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$5;

            public final String apply(int x$5) {
                return SerDe$.MODULE$.readString(this.in$5);
            }
            {
                this.in$5 = in$5;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArray(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        Object object;
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            default: {
                if (this.org$apache$spark$api$r$SerDe$$sqlReadObject == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid array type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)arrType)})));
                }
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(dis, arrType){
                    public static final long serialVersionUID = 0L;
                    private final DataInputStream dis$1;
                    private final char arrType$1;

                    public final Object apply(int x$8) {
                        Object obj = SerDe$.MODULE$.org$apache$spark$api$r$SerDe$$sqlReadObject.apply((Object)this.dis$1, (Object)BoxesRunTime.boxToCharacter((char)this.arrType$1));
                        if (obj == null) {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid array type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.arrType$1)})));
                        }
                        return obj;
                    }
                    {
                        this.dis$1 = dis$1;
                        this.arrType$1 = arrType$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
                break;
            }
            case 'l': {
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(dis, jvmObjectTracker){
                    public static final long serialVersionUID = 0L;
                    private final DataInputStream dis$1;
                    private final JVMObjectTracker jvmObjectTracker$2;

                    public final Object[] apply(int x$7) {
                        return SerDe$.MODULE$.readList(this.dis$1, this.jvmObjectTracker$2);
                    }
                    {
                        this.dis$1 = dis$1;
                        this.jvmObjectTracker$2 = jvmObjectTracker$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
                break;
            }
            case 'a': {
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(dis, jvmObjectTracker){
                    public static final long serialVersionUID = 0L;
                    private final DataInputStream dis$1;
                    private final JVMObjectTracker jvmObjectTracker$2;

                    public final Object apply(int x$6) {
                        return SerDe$.MODULE$.readArray(this.dis$1, this.jvmObjectTracker$2);
                    }
                    {
                        this.dis$1 = dis$1;
                        this.jvmObjectTracker$2 = jvmObjectTracker$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
                break;
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'j': {
                object = Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis)).map((Function1)new Serializable(jvmObjectTracker){
                    public static final long serialVersionUID = 0L;
                    private final JVMObjectTracker jvmObjectTracker$2;

                    public final Object apply(String x) {
                        return this.jvmObjectTracker$2.apply(new JVMObjectId(x));
                    }
                    {
                        this.jvmObjectTracker$2 = jvmObjectTracker$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'i': {
                object = this.readIntArr(dis);
            }
        }
        return object;
    }

    public Object[] readList(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        int len = this.readInt(dis);
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)new Serializable(dis, jvmObjectTracker){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dis$2;
            private final JVMObjectTracker jvmObjectTracker$3;

            public final Object apply(int x$9) {
                return SerDe$.MODULE$.readObject(this.dis$2, this.jvmObjectTracker$3);
            }
            {
                this.dis$2 = dis$2;
                this.jvmObjectTracker$3 = jvmObjectTracker$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public java.util.Map<Object, Object> readMap(DataInputStream in, JVMObjectTracker jvmObjectTracker) {
        java.util.Map<Object, Object> map2;
        int len = this.readInt(in);
        if (len > 0) {
            Object[] keys2 = (Object[])this.readArray(in, jvmObjectTracker);
            Object[] values2 = this.readList(in, jvmObjectTracker);
            map2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(keys2).zip((GenIterable)Predef$.MODULE$.wrapRefArray(values2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava();
        } else {
            map2 = new HashMap<Object, Object>();
        }
        return map2;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        block14: {
            block3: {
                String string;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            string = typeStr;
                                                            if (!"void".equals(string)) break block2;
                                                            dos.writeByte(110);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (!"character".equals(string)) break block4;
                                                        dos.writeByte(99);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!"double".equals(string)) break block5;
                                                    dos.writeByte(100);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!"integer".equals(string)) break block6;
                                                dos.writeByte(105);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!"logical".equals(string)) break block7;
                                            dos.writeByte(98);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!"date".equals(string)) break block8;
                                        dos.writeByte(68);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!"time".equals(string)) break block9;
                                    dos.writeByte(116);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!"raw".equals(string)) break block10;
                                dos.writeByte(114);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!"array".equals(string)) break block11;
                            dos.writeByte(97);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"list".equals(string)) break block12;
                        dos.writeByte(108);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!"map".equals(string)) break block13;
                    dos.writeByte(101);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!"jobj".equals(string)) break block14;
                dos.writeByte(106);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeStr})));
    }

    public void org$apache$spark$api$r$SerDe$$writeKeyValue(DataOutputStream dos, Object key, Object value2, JVMObjectTracker jvmObjectTracker) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (key instanceof String) {
            this.writeString(dos, (String)key);
            this.writeObject(dos, value2, jvmObjectTracker);
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid map key type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.getClass().getName()})));
    }

    public void writeObject(DataOutputStream dos, Object obj, JVMObjectTracker jvmObjectTracker) {
        if (obj == null) {
            this.writeType(dos, "void");
        } else {
            Object value2 = obj instanceof WrappedArray ? ((WrappedArray)obj).toArray(ClassTag$.MODULE$.apply(Object.class)) : obj;
            Object object = value2;
            if (object instanceof Character) {
                Character c = (Character)object;
                this.writeType(dos, "character");
                this.writeString(dos, c.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                this.writeType(dos, "character");
                this.writeString(dos, string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                Long l = (Long)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                Float f = (Float)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Float2float(f));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                Double d = (Double)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                Byte by = (Byte)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                Short s = (Short)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Short2short(s));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                this.writeType(dos, "logical");
                this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Date) {
                Date date = (Date)object;
                this.writeType(dos, "date");
                this.writeDate(dos, date);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Time) {
                Time time = (Time)object;
                this.writeType(dos, "time");
                this.writeTime(dos, time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                this.writeType(dos, "time");
                this.writeTime(dos, timestamp);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                this.writeType(dos, "raw");
                this.writeBytes(dos, byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                this.writeType(dos, "array");
                this.writeStringArr(dos, (String[])Predef$.MODULE$.charArrayOps(cArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$10) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$10)).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, (int[])Predef$.MODULE$.shortArrayOps(sArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(short x$11) {
                        return x$11;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, nArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])Predef$.MODULE$.longArrayOps(lArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(long x$12) {
                        return this.apply$mcDJ$sp(x$12);
                    }

                    public double apply$mcDJ$sp(long x$12) {
                        return x$12;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])Predef$.MODULE$.floatArrayOps(fArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$13) {
                        return this.apply$mcDF$sp(x$13);
                    }

                    public double apply$mcDF$sp(float x$13) {
                        return x$13;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, dArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                this.writeType(dos, "array");
                this.writeBooleanArr(dos, blArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.writeType(dos, "list");
                this.writeInt(dos, objectArray.length);
                Predef$.MODULE$.refArrayOps(objectArray).foreach((Function1)new Serializable(dos, jvmObjectTracker){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;
                    private final JVMObjectTracker jvmObjectTracker$1;

                    public final void apply(Object elem) {
                        SerDe$.MODULE$.writeObject(this.dos$1, elem, this.jvmObjectTracker$1);
                    }
                    {
                        this.dos$1 = dos$1;
                        this.jvmObjectTracker$1 = jvmObjectTracker$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Properties) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value2, jvmObjectTracker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.Map) {
                java.util.Map map2 = (java.util.Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map2.size());
                for (Map.Entry entry : map2.entrySet()) {
                    Object key = entry.getKey();
                    Object value3 = entry.getValue();
                    this.org$apache$spark$api$r$SerDe$$writeKeyValue(dos, key, value3, jvmObjectTracker);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Map) {
                Map map3 = (Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map3.size());
                map3.foreach((Function1)new Serializable(dos, jvmObjectTracker){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;
                    private final JVMObjectTracker jvmObjectTracker$1;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k1 = tuple2._1();
                            Object v1 = tuple2._2();
                            SerDe$.MODULE$.org$apache$spark$api$r$SerDe$$writeKeyValue(this.dos$1, k1, v1, this.jvmObjectTracker$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.dos$1 = dos$1;
                        this.jvmObjectTracker$1 = jvmObjectTracker$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                boolean sqlWriteSucceeded;
                boolean bl = sqlWriteSucceeded = this.sqlWriteObject != null && BoxesRunTime.unboxToBoolean((Object)this.sqlWriteObject.apply((Object)dos, value2));
                if (sqlWriteSucceeded) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.writeType(dos, "jobj");
                    this.writeJObj(dos, value2, jvmObjectTracker);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        }
    }

    public void writeInt(DataOutputStream out, int value2) {
        out.writeInt(value2);
    }

    public void writeDouble(DataOutputStream out, double value2) {
        out.writeDouble(value2);
    }

    public void writeBoolean(DataOutputStream out, boolean value2) {
        int intValue = value2 ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value2) {
        this.writeString(out, value2.toString());
    }

    public void writeTime(DataOutputStream out, Time value2) {
        out.writeDouble((double)value2.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value2) {
        out.writeDouble((double)(value2.getTime() / 1000L) + (double)value2.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value2) {
        byte[] utf8 = value2.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value2) {
        out.writeInt(value2.length);
        out.write(value2);
    }

    public void writeJObj(DataOutputStream out, Object value2, JVMObjectTracker jvmObjectTracker) {
        JVMObjectId jVMObjectId = jvmObjectTracker.addAndGetId(value2);
        if (jVMObjectId != null) {
            String id;
            String string;
            String id2 = string = (id = jVMObjectId.id());
            this.writeString(out, id2);
            return;
        }
        throw new MatchError((Object)jVMObjectId);
    }

    public void writeIntArr(DataOutputStream out, int[] value2) {
        this.writeType(out, "integer");
        out.writeInt(value2.length);
        Predef$.MODULE$.intArrayOps(value2).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$2;

            public final void apply(int v) {
                this.apply$mcVI$sp(v);
            }

            public void apply$mcVI$sp(int v) {
                this.out$2.writeInt(v);
            }
            {
                this.out$2 = out$2;
            }
        });
    }

    public void writeDoubleArr(DataOutputStream out, double[] value2) {
        this.writeType(out, "double");
        out.writeInt(value2.length);
        Predef$.MODULE$.doubleArrayOps(value2).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                this.out$3.writeDouble(v);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value2) {
        this.writeType(out, "logical");
        out.writeInt(value2.length);
        Predef$.MODULE$.booleanArrayOps(value2).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$4;

            public final void apply(boolean v) {
                SerDe$.MODULE$.writeBoolean(this.out$4, v);
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value2) {
        this.writeType(out, "character");
        out.writeInt(value2.length);
        Predef$.MODULE$.refArrayOps((Object[])value2).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;

            public final void apply(String v) {
                SerDe$.MODULE$.writeString(this.out$1, v);
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    private SerDe$() {
        MODULE$ = this;
    }
}

