/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.support;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springdata20.repository.support.IgniteRepositoryFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class IgniteRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext ctx;

    protected IgniteRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.ctx = context;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        try {
            Ignite ignite = (Ignite)this.ctx.getBean("igniteInstance");
            return new IgniteRepositoryFactory(ignite, this.ctx);
        }
        catch (BeansException ex) {
            try {
                IgniteConfiguration cfg = (IgniteConfiguration)this.ctx.getBean("igniteCfg");
                return new IgniteRepositoryFactory(cfg, this.ctx);
            }
            catch (BeansException ex2) {
                try {
                    String path = (String)this.ctx.getBean("igniteSpringCfgPath");
                    return new IgniteRepositoryFactory(path, this.ctx);
                }
                catch (BeansException ex3) {
                    throw new IgniteException("Failed to initialize Ignite repository factory. Ignite instance or IgniteConfiguration or a path to Ignite's spring XML configuration must be defined in the application configuration");
                }
            }
        }
    }
}

