/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata20.repository.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springdata20.repository.IgniteRepository;
import org.apache.ignite.springdata20.repository.config.Query;
import org.apache.ignite.springdata20.repository.config.RepositoryConfig;
import org.apache.ignite.springdata20.repository.query.IgniteQuery;
import org.apache.ignite.springdata20.repository.query.IgniteQueryGenerator;
import org.apache.ignite.springdata20.repository.query.IgniteRepositoryQuery;
import org.apache.ignite.springdata20.repository.support.IgniteRepositoryImpl;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IgniteRepositoryFactory
extends RepositoryFactorySupport {
    private Ignite ignite;
    private ApplicationContext ctx;
    private DefaultListableBeanFactory beanFactory;
    private StandardBeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext beanExpressionContext;
    private final Map<Class<?>, String> repoToCache = new HashMap();

    public IgniteRepositoryFactory(Ignite ignite, ApplicationContext ctx) {
        this.ignite = ignite;
        this.ctx = ctx;
        this.beanFactory = new DefaultListableBeanFactory((BeanFactory)ctx.getAutowireCapableBeanFactory());
        this.beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null);
    }

    public IgniteRepositoryFactory(IgniteConfiguration cfg, ApplicationContext ctx) {
        this.ignite = Ignition.start((IgniteConfiguration)cfg);
        this.ctx = ctx;
        this.beanFactory = new DefaultListableBeanFactory((BeanFactory)ctx.getAutowireCapableBeanFactory());
        this.beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null);
    }

    public IgniteRepositoryFactory(String springCfgPath, ApplicationContext ctx) {
        this.ignite = Ignition.start((String)springCfgPath);
        this.ctx = ctx;
        this.beanFactory = new DefaultListableBeanFactory((BeanFactory)ctx.getAutowireCapableBeanFactory());
        this.beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null);
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new AbstractEntityInformation<T, ID>(domainClass){

            public ID getId(T entity) {
                return null;
            }

            public Class<ID> getIdType() {
                return null;
            }
        };
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return IgniteRepositoryImpl.class;
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repoItf) {
        Assert.notNull(repoItf, (String)"Repository interface must be set.");
        Assert.isAssignable(IgniteRepository.class, repoItf, (String)"Repository must implement IgniteRepository interface.");
        RepositoryConfig annotation = repoItf.getAnnotation(RepositoryConfig.class);
        Assert.notNull((Object)annotation, (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        Assert.hasText((String)annotation.cacheName(), (String)"Set a name of an Apache Ignite cache using @RepositoryConfig annotation to map this repository to the underlying cache.");
        String cacheName = this.evaluateExpression(annotation.cacheName());
        this.repoToCache.put(repoItf, cacheName);
        return super.getRepositoryMetadata(repoItf);
    }

    @NotNull
    private String evaluateExpression(String spelExpression) {
        return (String)this.resolver.evaluate(spelExpression, this.beanExpressionContext);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.ignite.getOrCreateCache(this.repoToCache.get(metadata.getRepositoryInterface()))});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationCtxProvider) {
        return Optional.of((mtd, metadata, factory, namedQueries) -> {
            Query annotation = mtd.getAnnotation(Query.class);
            if (annotation != null) {
                String qryStr = annotation.value();
                if (key != QueryLookupStrategy.Key.CREATE && StringUtils.hasText((String)qryStr)) {
                    return new IgniteRepositoryQuery(metadata, new IgniteQuery(qryStr, this.isFieldQuery(qryStr), IgniteQueryGenerator.getOptions(mtd)), mtd, factory, this.ignite.getOrCreateCache(this.repoToCache.get(metadata.getRepositoryInterface())));
                }
            }
            if (key == QueryLookupStrategy.Key.USE_DECLARED_QUERY) {
                throw new IllegalStateException("To use QueryLookupStrategy.Key.USE_DECLARED_QUERY, pass a query string via org.apache.ignite.springdata.repository.config.Query annotation.");
            }
            return new IgniteRepositoryQuery(metadata, IgniteQueryGenerator.generateSql(mtd, metadata), mtd, factory, this.ignite.getOrCreateCache(this.repoToCache.get(metadata.getRepositoryInterface())));
        });
    }

    private boolean isFieldQuery(String qry) {
        String qryUpperCase = qry.toUpperCase();
        return this.isStatement(qryUpperCase) && !qryUpperCase.matches("^SELECT\\s+(?:\\w+\\.)?+\\*.*");
    }

    private boolean isStatement(String qryUpperCase) {
        return qryUpperCase.matches("^\\s*SELECT\\b.*") || qryUpperCase.matches("^\\s*UPDATE\\b.*") || qryUpperCase.matches("^\\s*DELETE\\b.*") || qryUpperCase.matches("^\\s*MERGE\\b.*") || qryUpperCase.matches("^\\s*INSERT\\b.*");
    }
}

