/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskContinuousMapper;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.GridInternalWrapper;
import org.apache.ignite.internal.GridJobContextImpl;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.resource.GridResourceBasicInjector;
import org.apache.ignite.internal.processors.resource.GridResourceInjector;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.processors.resource.GridResourceJobContextInjector;
import org.apache.ignite.internal.processors.resource.GridResourceLoggerInjector;
import org.apache.ignite.internal.processors.resource.GridResourceMethod;
import org.apache.ignite.internal.processors.resource.GridResourceServiceInjector;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.services.Service;
import org.apache.ignite.spi.IgniteSpi;
import org.jetbrains.annotations.Nullable;

public class GridResourceProcessor
extends GridProcessorAdapter {
    private final GridResourceInjector nullInjector = new GridResourceBasicInjector<Object>(null);
    private GridSpringResourceContext rsrcCtx;
    private final GridResourceIoc ioc = new GridResourceIoc();
    private final GridResourceInjector[] injectorByAnnotation = new GridResourceInjector[GridResourceIoc.ResourceAnnotation.values().length];

    public GridResourceProcessor(GridKernalContext ctx) {
        super(ctx);
        this.injectorByAnnotation[GridResourceIoc.ResourceAnnotation.SERVICE.ordinal()] = new GridResourceServiceInjector(ctx.grid());
        this.injectorByAnnotation[GridResourceIoc.ResourceAnnotation.LOGGER.ordinal()] = new GridResourceLoggerInjector(ctx.config().getGridLogger());
        this.injectorByAnnotation[GridResourceIoc.ResourceAnnotation.IGNITE_INSTANCE.ordinal()] = new GridResourceBasicInjector<IgniteEx>(ctx.grid());
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started resource processor.");
        }
    }

    @Override
    public void stop(boolean cancel) {
        this.ioc.undeployAll();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped resource processor.");
        }
    }

    public void setSpringContext(@Nullable GridSpringResourceContext rsrcCtx) {
        GridResourceInjector springBeanInjector;
        this.rsrcCtx = rsrcCtx;
        GridResourceInjector springCtxInjector = rsrcCtx != null ? rsrcCtx.springContextInjector() : this.nullInjector;
        this.injectorByAnnotation[GridResourceIoc.ResourceAnnotation.SPRING.ordinal()] = springBeanInjector = rsrcCtx != null ? rsrcCtx.springBeanInjector() : this.nullInjector;
        this.injectorByAnnotation[GridResourceIoc.ResourceAnnotation.SPRING_APPLICATION_CONTEXT.ordinal()] = springCtxInjector;
    }

    public void onUndeployed(GridDeployment dep) {
        this.ioc.onUndeployed(dep.classLoader());
    }

    public void invokeAnnotated(GridDeployment dep, Object target, Class<? extends Annotation> annCls) throws IgniteCheckedException {
        if (target != null) {
            GridResourceMethod[] rsrcMtds;
            for (GridResourceMethod rsrcMtd : rsrcMtds = this.ioc.getMethodsWithAnnotation(dep, target.getClass(), annCls)) {
                Method mtd = rsrcMtd.getMethod();
                try {
                    mtd.invoke(target, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new IgniteCheckedException("Failed to invoke annotated method [job=" + target + ", mtd=" + mtd + ", ann=" + annCls + ']', e);
                }
            }
        }
    }

    public void inject(GridDeployment dep, Class<?> depCls, Object target) throws IgniteCheckedException {
        assert (target != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Injecting resources", "target", target, true));
        }
        target = this.unwrapTarget(target);
        this.inject(target, GridResourceIoc.AnnotationSet.GENERIC, dep, depCls, new Object[0]);
    }

    public void injectCacheName(Object obj, String cacheName) throws IgniteCheckedException {
        assert (obj != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injecting cache name: " + obj);
        }
        obj = this.unwrapTarget(obj);
        this.inject(obj, GridResourceIoc.ResourceAnnotation.CACHE_NAME, null, null, (Object)cacheName);
    }

    public boolean injectStoreSession(Object obj, CacheStoreSession ses) throws IgniteCheckedException {
        assert (obj != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injecting cache store session: " + obj);
        }
        obj = this.unwrapTarget(obj);
        return this.inject(obj, GridResourceIoc.ResourceAnnotation.CACHE_STORE_SESSION, null, null, (Object)ses);
    }

    public boolean injectFileSystem(Object obj, IgniteFileSystem igfs) throws IgniteCheckedException {
        assert (obj != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injecting cache store session: " + obj);
        }
        obj = this.unwrapTarget(obj);
        return this.inject(obj, GridResourceIoc.ResourceAnnotation.FILESYSTEM_RESOURCE, null, null, (Object)igfs);
    }

    public void injectGeneric(Object obj) throws IgniteCheckedException {
        this.inject(obj, GridResourceIoc.AnnotationSet.GENERIC, new Object[0]);
    }

    public void inject(Object obj, GridResourceIoc.AnnotationSet annSet, Object ... params) throws IgniteCheckedException {
        assert (obj != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Injecting resources", "obj", obj, true));
        }
        obj = this.unwrapTarget(obj);
        this.inject(obj, annSet, null, null, params);
    }

    private void inject(Object obj, GridResourceIoc.AnnotationSet annSet, @Nullable GridDeployment dep, @Nullable Class<?> depCls, Object ... params) throws IgniteCheckedException {
        GridResourceIoc.ClassDescriptor clsDesc = this.ioc.descriptor(null, obj.getClass());
        assert (clsDesc != null);
        if (clsDesc.isAnnotated(annSet) == 0) {
            return;
        }
        int i = 0;
        for (GridResourceIoc.ResourceAnnotation ann : annSet.annotations) {
            GridResourceInjector injector;
            if (clsDesc.isAnnotated(ann) && (injector = this.injectorByAnnotation(ann, i < params.length ? params[i] : null)) != null) {
                clsDesc.inject(obj, ann, injector, dep, depCls);
            }
            ++i;
        }
    }

    private void cleanup(Object obj, GridResourceIoc.AnnotationSet annSet) throws IgniteCheckedException {
        assert (obj != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cleaning up resources: " + obj);
        }
        obj = this.unwrapTarget(obj);
        GridResourceIoc.ClassDescriptor clsDesc = this.ioc.descriptor(null, obj.getClass());
        assert (clsDesc != null);
        if (clsDesc.isAnnotated(annSet) == 0) {
            return;
        }
        for (GridResourceIoc.ResourceAnnotation ann : annSet.annotations) {
            clsDesc.inject(obj, ann, this.nullInjector, null, null);
        }
    }

    private GridResourceInjector injectorByAnnotation(GridResourceIoc.ResourceAnnotation ann, Object param) {
        GridResourceInjector res;
        switch (ann) {
            case CACHE_NAME: 
            case TASK_SESSION: 
            case LOAD_BALANCER: 
            case TASK_CONTINUOUS_MAPPER: 
            case CACHE_STORE_SESSION: 
            case FILESYSTEM_RESOURCE: {
                res = new GridResourceBasicInjector(param);
                break;
            }
            case JOB_CONTEXT: {
                res = new GridResourceJobContextInjector((ComputeJobContext)param);
                break;
            }
            default: {
                res = this.injectorByAnnotation[ann.ordinal()];
            }
        }
        return res;
    }

    private boolean inject(Object obj, GridResourceIoc.ResourceAnnotation ann, @Nullable GridDeployment dep, @Nullable Class<?> depCls, Object param) throws IgniteCheckedException {
        GridResourceInjector injector;
        GridResourceIoc.ClassDescriptor clsDesc = this.ioc.descriptor(null, obj.getClass());
        assert (clsDesc != null);
        if (clsDesc.isAnnotated(ann) && (injector = this.injectorByAnnotation(ann, param)) != null) {
            return clsDesc.inject(obj, ann, injector, dep, depCls);
        }
        return false;
    }

    public void cleanupGeneric(Object obj) throws IgniteCheckedException {
        if (obj != null) {
            this.cleanup(obj, GridResourceIoc.AnnotationSet.GENERIC);
        }
    }

    public void inject(GridDeployment dep, Class<?> taskCls, ComputeJob job, ComputeTaskSession ses, GridJobContextImpl jobCtx) throws IgniteCheckedException {
        Object usrObj;
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Injecting resources", "job", job, true));
        }
        Object obj = this.unwrapTarget(job);
        this.injectToJob(dep, taskCls, obj, ses, jobCtx);
        if (obj instanceof GridInternalWrapper && (usrObj = ((GridInternalWrapper)obj).userObject()) != null) {
            this.injectToJob(dep, taskCls, usrObj, ses, jobCtx);
        }
    }

    private void injectToJob(GridDeployment dep, Class<?> taskCls, Object job, ComputeTaskSession ses, GridJobContextImpl jobCtx) throws IgniteCheckedException {
        this.inject(job, GridResourceIoc.AnnotationSet.JOB, dep, taskCls, ses, jobCtx);
    }

    public void inject(GridDeployment dep, ComputeTask<?, ?> task, GridTaskSessionImpl ses, ComputeLoadBalancer balancer, ComputeTaskContinuousMapper mapper) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Injecting resources", "task", task, true));
        }
        Object obj = this.unwrapTarget(task);
        this.inject(obj, GridResourceIoc.AnnotationSet.TASK, dep, null, ses, balancer, mapper);
    }

    public boolean isAnnotationPresent(GridDeployment dep, Object target, Class<? extends Annotation> annCls) {
        return this.ioc.isAnnotationPresent(target, annCls, dep);
    }

    public boolean isAnnotationsPresent(GridDeployment dep, Object target, GridResourceIoc.AnnotationSet annSet) {
        return this.ioc.isAnnotationsPresent(dep, target, annSet);
    }

    public void inject(IgniteSpi spi) throws IgniteCheckedException {
        this.injectGeneric(spi);
    }

    public void cleanup(IgniteSpi spi) throws IgniteCheckedException {
        this.cleanupGeneric(spi);
    }

    public void inject(LifecycleBean lifecycleBean) throws IgniteCheckedException {
        this.injectGeneric(lifecycleBean);
    }

    public void cleanup(LifecycleBean lifecycleBean) throws IgniteCheckedException {
        this.cleanupGeneric(lifecycleBean);
    }

    public void inject(Service svc) throws IgniteCheckedException {
        this.injectGeneric(svc);
    }

    public void cleanup(Service svc) throws IgniteCheckedException {
        this.cleanupGeneric(svc);
    }

    public void injectBasicResource(Object target, Class<? extends Annotation> annCls, Object rsrc) throws IgniteCheckedException {
        assert (!(rsrc instanceof GridResourceInjector)) : "Invalid injection.";
        this.ioc.inject(target, annCls, new GridResourceBasicInjector<Object>(rsrc), null, null);
    }

    GridResourceIoc getResourceIoc() {
        return this.ioc;
    }

    private Object unwrapTarget(Object target) throws IgniteCheckedException {
        return this.rsrcCtx != null ? this.rsrcCtx.unwrapTarget(target) : target;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Resource processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        this.ioc.printMemoryStats();
    }
}

