/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryResponse;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClientCacheScanQueryRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private static final byte FILTER_PLATFORM_JAVA = 1;
    private static final byte FILTER_PLATFORM_DOTNET = 2;
    private static final byte FILTER_PLATFORM_CPP = 3;
    private final boolean loc;
    private final int pageSize;
    private final Integer part;
    private final byte filterPlatform;
    private final Object filterObj;

    public ClientCacheScanQueryRequest(BinaryRawReaderEx reader) {
        super(reader);
        this.filterObj = reader.readObjectDetached();
        this.filterPlatform = this.filterObj == null ? (byte)0 : reader.readByte();
        this.pageSize = reader.readInt();
        int part0 = reader.readInt();
        this.part = part0 < 0 ? null : Integer.valueOf(part0);
        this.loc = reader.readBoolean();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache cache = this.filterPlatform == 1 && !this.isKeepBinary() ? this.rawCache(ctx) : this.cache(ctx);
        ScanQuery qry = ((ScanQuery)((ScanQuery)new ScanQuery().setLocal(this.loc)).setPageSize(this.pageSize)).setPartition(this.part).setFilter(this.createFilter(ctx));
        ctx.incrementCursors();
        try {
            QueryCursor<Cache.Entry> cur = cache.query(qry);
            ClientCacheEntryQueryCursor cliCur = new ClientCacheEntryQueryCursor(cur, this.pageSize, ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheQueryResponse(this.requestId(), cliCur);
        }
        catch (Exception e) {
            ctx.decrementCursors();
            throw e;
        }
    }

    private IgniteBiPredicate createFilter(ClientConnectionContext ctx) {
        if (this.filterObj == null) {
            return null;
        }
        switch (this.filterPlatform) {
            case 1: {
                return (IgniteBiPredicate)((BinaryObject)this.filterObj).deserialize();
            }
            case 2: {
                PlatformContext platformCtx = ctx.kernalContext().platform().context();
                String curPlatform = platformCtx.platform();
                if (!"dotnet".equals(curPlatform)) {
                    throw new IgniteException("ScanQuery filter platform is dotnet, current platform is " + curPlatform);
                }
                return platformCtx.createCacheEntryFilter(this.filterObj, 0L);
            }
        }
        throw new UnsupportedOperationException("Invalid client ScanQuery filter code: " + this.filterPlatform);
    }
}

