/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.platform.client.ClientAffinityTopologyVersion;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientFlag;

public class ClientResponse
extends ClientListenerResponse {
    private final long reqId;

    public ClientResponse(long reqId) {
        super(0, null);
        this.reqId = reqId;
    }

    public ClientResponse(long reqId, String err) {
        super(1, err);
        this.reqId = reqId;
    }

    public ClientResponse(long reqId, int status, String err) {
        super(status, err);
        this.reqId = reqId;
    }

    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer, ClientAffinityTopologyVersion affinityVer) {
        writer.writeLong(this.reqId);
        ClientListenerProtocolVersion ver = ctx.currentVersion();
        assert (ver != null);
        if (ver.compareTo(ClientConnectionContext.VER_1_4_0) >= 0) {
            boolean error = this.status() != 0;
            short flags = ClientFlag.makeFlags(error, affinityVer.isChanged());
            writer.writeShort(flags);
            if (affinityVer.isChanged()) {
                affinityVer.write(writer);
            }
            if (!error) {
                return;
            }
        }
        writer.writeInt(this.status());
        if (this.status() != 0) {
            writer.writeString(this.error());
        }
    }

    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        this.encode(ctx, writer, ctx.checkAffinityTopologyVersion());
    }

    public long requestId() {
        return this.reqId;
    }
}

