/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryFetchRequest
extends JdbcRequest {
    private long cursorId;
    private int pageSize;

    JdbcQueryFetchRequest() {
        super((byte)3);
    }

    public JdbcQueryFetchRequest(long cursorId, int pageSize) {
        super((byte)3);
        this.cursorId = cursorId;
        this.pageSize = pageSize;
    }

    public long cursorId() {
        return this.cursorId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeLong(this.cursorId);
        writer.writeInt(this.pageSize);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.cursorId = reader.readLong();
        this.pageSize = reader.readInt();
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryFetchRequest.class, this);
    }
}

