/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.marshaller.MarshallerContext;

class ClientBinaryMarshaller {
    private final BinaryMetadataHandler metaHnd;
    private final MarshallerContext marshCtx;
    private GridBinaryMarshaller impl;

    ClientBinaryMarshaller(BinaryMetadataHandler metaHnd, MarshallerContext marshCtx) {
        this.metaHnd = metaHnd;
        this.marshCtx = marshCtx;
        this.impl = this.createImpl(null);
    }

    public <T> T unmarshal(BinaryInputStream in) {
        return this.impl.unmarshal(in);
    }

    public <T> T deserialize(BinaryInputStream in, BinaryReaderHandles hnds) {
        return this.impl.deserialize(in, null, hnds);
    }

    public byte[] marshal(Object obj) {
        return this.impl.marshal(obj, false);
    }

    public void setBinaryConfiguration(BinaryConfiguration binCfg) {
        if (this.impl.context().configuration().getBinaryConfiguration() != binCfg) {
            this.impl = this.createImpl(binCfg);
        }
    }

    public BinaryContext context() {
        return this.impl.context();
    }

    private GridBinaryMarshaller createImpl(BinaryConfiguration binCfg) {
        IgniteConfiguration igniteCfg = new IgniteConfiguration();
        if (binCfg == null) {
            binCfg = new BinaryConfiguration();
            binCfg.setCompactFooter(false);
        }
        igniteCfg.setBinaryConfiguration(binCfg);
        BinaryContext ctx = new BinaryContext(this.metaHnd, igniteCfg, new NullLogger());
        BinaryMarshaller marsh = new BinaryMarshaller();
        marsh.setContext(this.marshCtx);
        ctx.configure(marsh, igniteCfg);
        ctx.registerUserTypesSchema();
        return new GridBinaryMarshaller(ctx);
    }
}

