/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public abstract class GridSqlQuery
extends GridSqlStatement
implements GridSqlAst {
    public static final int OFFSET_CHILD = 0;
    public static final int LIMIT_CHILD = 1;
    protected List<GridSqlSortColumn> sort = new ArrayList<GridSqlSortColumn>();
    private GridSqlAst offset;

    public GridSqlAst offset() {
        return this.offset;
    }

    public void offset(GridSqlAst offset) {
        this.offset = offset;
    }

    public List<GridSqlSortColumn> sort() {
        return this.sort;
    }

    public void clearSort() {
        this.sort = new ArrayList<GridSqlSortColumn>();
    }

    public void addSort(GridSqlSortColumn sortCol) {
        this.sort.add(sortCol);
    }

    protected abstract int visibleColumns();

    protected abstract GridSqlAst column(int var1);

    @Override
    public GridSqlType resultType() {
        return GridSqlType.RESULT_SET;
    }

    @Override
    public <E extends GridSqlAst> E child() {
        return this.child(0);
    }

    @Override
    public <E extends GridSqlAst> E child(int childIdx) {
        switch (childIdx) {
            case 0: {
                return GridSqlQuery.maskNull(this.offset, GridSqlPlaceholder.EMPTY);
            }
            case 1: {
                return GridSqlQuery.maskNull(this.limit, GridSqlPlaceholder.EMPTY);
            }
        }
        throw new IllegalStateException("Child index: " + childIdx);
    }

    protected static <E extends GridSqlAst> E maskNull(GridSqlAst x, GridSqlAst dflt) {
        return (E)(x == null ? dflt : x);
    }

    @Override
    public <E extends GridSqlAst> void child(int childIdx, E child) {
        switch (childIdx) {
            case 0: {
                this.offset = child;
                break;
            }
            case 1: {
                this.limit = child;
                break;
            }
            default: {
                throw new IllegalStateException("Child index: " + childIdx);
            }
        }
    }

    public abstract boolean skipMergeTable();

    protected void getSortLimitSQL(StatementBuilder buff) {
        if (!this.sort.isEmpty()) {
            buff.append("\nORDER BY ");
            int visibleCols = this.visibleColumns();
            buff.resetCount();
            for (GridSqlSortColumn col : this.sort) {
                buff.appendExceptFirst(", ");
                int idx = col.column();
                assert (idx >= 0) : idx;
                if (idx < visibleCols) {
                    buff.append((long)(idx + 1));
                } else {
                    GridSqlAst expr = this.column(idx);
                    if (expr == null) {
                        throw new IllegalStateException("Failed to build query: " + buff.toString());
                    }
                    if (expr instanceof GridSqlAlias) {
                        expr = expr.child(0);
                    }
                    buff.append('=').append(StringUtils.unEnclose((String)expr.getSQL()));
                }
                if (!col.asc()) {
                    buff.append(" DESC");
                }
                if (col.nullsFirst()) {
                    buff.append(" NULLS FIRST");
                    continue;
                }
                if (!col.nullsLast()) continue;
                buff.append(" NULLS LAST");
            }
        }
        if (this.limit != null) {
            buff.append(" LIMIT ").append(StringUtils.unEnclose((String)this.limit.getSQL()));
        }
        if (this.offset != null) {
            buff.append(" OFFSET ").append(StringUtils.unEnclose((String)this.offset.getSQL()));
        }
    }

    public boolean hasOffsetLimit() {
        return this.limit() != null || this.offset() != null;
    }
}

