/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.client;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.util.TransportFrameDecoder;

class StreamInterceptor
implements TransportFrameDecoder.Interceptor {
    private final TransportResponseHandler handler;
    private final String streamId;
    private final long byteCount;
    private final StreamCallback callback;
    private long bytesRead;

    StreamInterceptor(TransportResponseHandler handler, String streamId, long byteCount, StreamCallback callback) {
        this.handler = handler;
        this.streamId = streamId;
        this.byteCount = byteCount;
        this.callback = callback;
        this.bytesRead = 0L;
    }

    @Override
    public void exceptionCaught(Throwable cause) throws Exception {
        this.handler.deactivateStream();
        this.callback.onFailure(this.streamId, cause);
    }

    @Override
    public void channelInactive() throws Exception {
        this.handler.deactivateStream();
        this.callback.onFailure(this.streamId, new ClosedChannelException());
    }

    @Override
    public boolean handle(ByteBuf buf) throws Exception {
        int toRead = (int)Math.min((long)buf.readableBytes(), this.byteCount - this.bytesRead);
        ByteBuffer nioBuffer = buf.readSlice(toRead).nioBuffer();
        int available = nioBuffer.remaining();
        this.callback.onData(this.streamId, nioBuffer);
        this.bytesRead += (long)available;
        if (this.bytesRead > this.byteCount) {
            IllegalStateException re = new IllegalStateException(String.format("Read too many bytes? Expected %d, but read %d.", this.byteCount, this.bytesRead));
            this.callback.onFailure(this.streamId, re);
            this.handler.deactivateStream();
            throw re;
        }
        if (this.bytesRead == this.byteCount) {
            this.handler.deactivateStream();
            this.callback.onComplete(this.streamId);
        }
        return this.bytesRead != this.byteCount;
    }
}

