/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.interceptor.Interceptor;
import org.apache.flume.interceptor.InterceptorBuilderFactory;
import org.apache.flume.interceptor.InterceptorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProcessor
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelProcessor.class);
    private final ChannelSelector selector;
    private final InterceptorChain interceptorChain;

    public ChannelProcessor(ChannelSelector selector) {
        this.selector = selector;
        this.interceptorChain = new InterceptorChain();
    }

    public void initialize() {
        this.interceptorChain.initialize();
    }

    public void close() {
        this.interceptorChain.close();
    }

    @Override
    public void configure(Context context) {
        this.configureInterceptors(context);
    }

    private void configureInterceptors(Context context) {
        LinkedList interceptors = Lists.newLinkedList();
        String interceptorListStr = context.getString("interceptors", "");
        if (interceptorListStr.isEmpty()) {
            return;
        }
        String[] interceptorNames = interceptorListStr.split("\\s+");
        Context interceptorContexts = new Context((Map)context.getSubProperties("interceptors."));
        InterceptorBuilderFactory factory = new InterceptorBuilderFactory();
        for (String interceptorName : interceptorNames) {
            Context interceptorContext = new Context((Map)interceptorContexts.getSubProperties(interceptorName + "."));
            String type = interceptorContext.getString("type");
            if (type == null) {
                LOG.error("Type not specified for interceptor " + interceptorName);
                throw new FlumeException("Interceptor.Type not specified for " + interceptorName);
            }
            try {
                Interceptor.Builder builder = InterceptorBuilderFactory.newInstance(type);
                builder.configure(interceptorContext);
                interceptors.add(builder.build());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Builder class not found. Exception follows.", (Throwable)e);
                throw new FlumeException("Interceptor.Builder not found.", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error("Could not instantiate Builder. Exception follows.", (Throwable)e);
                throw new FlumeException("Interceptor.Builder not constructable.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Unable to access Builder. Exception follows.", (Throwable)e);
                throw new FlumeException("Unable to access Interceptor.Builder.", (Throwable)e);
            }
        }
        this.interceptorChain.setInterceptors(interceptors);
    }

    public ChannelSelector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEventBatch(List<Event> events) {
        List batch;
        Transaction tx;
        Preconditions.checkNotNull(events, (Object)"Event list must not be null");
        events = this.interceptorChain.intercept(events);
        LinkedHashMap<Channel, ArrayList<Event>> reqChannelQueue = new LinkedHashMap<Channel, ArrayList<Event>>();
        LinkedHashMap<Channel, ArrayList<Event>> optChannelQueue = new LinkedHashMap<Channel, ArrayList<Event>>();
        for (Event event : events) {
            List<Channel> reqChannels = this.selector.getRequiredChannels(event);
            for (Channel ch : reqChannels) {
                ArrayList<Event> eventQueue = (ArrayList<Event>)reqChannelQueue.get(ch);
                if (eventQueue == null) {
                    eventQueue = new ArrayList<Event>();
                    reqChannelQueue.put(ch, eventQueue);
                }
                eventQueue.add(event);
            }
            List<Channel> optChannels = this.selector.getOptionalChannels(event);
            for (Channel ch : optChannels) {
                ArrayList<Event> eventQueue = (ArrayList<Event>)optChannelQueue.get(ch);
                if (eventQueue == null) {
                    eventQueue = new ArrayList<Event>();
                    optChannelQueue.put(ch, eventQueue);
                }
                eventQueue.add(event);
            }
        }
        for (Channel reqChannel : reqChannelQueue.keySet()) {
            tx = reqChannel.getTransaction();
            Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
            try {
                tx.begin();
                batch = (List)reqChannelQueue.get(reqChannel);
                for (Event event : batch) {
                    reqChannel.put(event);
                }
                tx.commit();
            }
            catch (Throwable t) {
                tx.rollback();
                if (t instanceof Error) {
                    LOG.error("Error while writing to required channel: " + reqChannel, t);
                    throw (Error)t;
                }
                if (t instanceof ChannelException) {
                    throw (ChannelException)t;
                }
                throw new ChannelException("Unable to put batch on required channel: " + reqChannel, t);
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        for (Channel optChannel : optChannelQueue.keySet()) {
            tx = optChannel.getTransaction();
            Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
            try {
                tx.begin();
                batch = (List)optChannelQueue.get(optChannel);
                for (Event event : batch) {
                    optChannel.put(event);
                }
                tx.commit();
            }
            catch (Throwable t) {
                tx.rollback();
                LOG.error("Unable to put batch on optional channel: " + optChannel, t);
                if (!(t instanceof Error)) continue;
                throw (Error)t;
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(Event event) {
        if ((event = this.interceptorChain.intercept(event)) == null) {
            return;
        }
        List<Channel> requiredChannels = this.selector.getRequiredChannels(event);
        for (Channel reqChannel : requiredChannels) {
            Transaction tx = reqChannel.getTransaction();
            Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
            try {
                tx.begin();
                reqChannel.put(event);
                tx.commit();
            }
            catch (Throwable t) {
                tx.rollback();
                if (t instanceof Error) {
                    LOG.error("Error while writing to required channel: " + reqChannel, t);
                    throw (Error)t;
                }
                if (t instanceof ChannelException) {
                    throw (ChannelException)t;
                }
                throw new ChannelException("Unable to put event on required channel: " + reqChannel, t);
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        List<Channel> optionalChannels = this.selector.getOptionalChannels(event);
        for (Channel optChannel : optionalChannels) {
            Transaction tx = null;
            try {
                tx = optChannel.getTransaction();
                tx.begin();
                optChannel.put(event);
                tx.commit();
            }
            catch (Throwable t) {
                tx.rollback();
                LOG.error("Unable to put event on optional channel: " + optChannel, t);
                if (!(t instanceof Error)) continue;
                throw (Error)t;
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }
}

