/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.BlockingQueueFactory;
import org.apache.camel.component.seda.LinkedBlockingQueueFactory;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaComponent
extends UriEndpointComponent {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final int maxConcurrentConsumers = 500;
    @Metadata(label="consumer", defaultValue="1")
    protected int concurrentConsumers = 1;
    @Metadata(label="advanced", defaultValue="1000")
    protected int queueSize = 1000;
    @Metadata(label="advanced")
    protected BlockingQueueFactory<Exchange> defaultQueueFactory = new LinkedBlockingQueueFactory<Exchange>();
    @Metadata(label="producer")
    private boolean defaultBlockWhenFull;
    @Metadata(label="producer")
    private long defaultOfferTimeout;
    private final Map<String, QueueReference> queues = new HashMap<String, QueueReference>();

    public SedaComponent() {
        super(SedaEndpoint.class);
    }

    public SedaComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setConcurrentConsumers(int size) {
        this.concurrentConsumers = size;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public BlockingQueueFactory<Exchange> getDefaultQueueFactory() {
        return this.defaultQueueFactory;
    }

    public void setDefaultQueueFactory(BlockingQueueFactory<Exchange> defaultQueueFactory) {
        this.defaultQueueFactory = defaultQueueFactory;
    }

    public boolean isDefaultBlockWhenFull() {
        return this.defaultBlockWhenFull;
    }

    public void setDefaultBlockWhenFull(boolean defaultBlockWhenFull) {
        this.defaultBlockWhenFull = defaultBlockWhenFull;
    }

    public long getDefaultOfferTimeout() {
        return this.defaultOfferTimeout;
    }

    public void setDefaultOfferTimeout(long defaultOfferTimeout) {
        this.defaultOfferTimeout = defaultOfferTimeout;
    }

    @Deprecated
    public synchronized QueueReference getOrCreateQueue(SedaEndpoint endpoint, Integer size) {
        return this.getOrCreateQueue(endpoint, size, null);
    }

    @Deprecated
    public synchronized QueueReference getOrCreateQueue(SedaEndpoint endpoint, Integer size, Boolean multipleConsumers) {
        return this.getOrCreateQueue(endpoint, size, multipleConsumers, null);
    }

    public synchronized QueueReference getOrCreateQueue(SedaEndpoint endpoint, Integer size, Boolean multipleConsumers, BlockingQueueFactory<Exchange> customQueueFactory) {
        BlockingQueue<Exchange> queue;
        BlockingQueueFactory<Exchange> queueFactory;
        String key = this.getQueueKey(endpoint.getEndpointUri());
        QueueReference ref = this.getQueues().get(key);
        if (ref != null) {
            if (size != null && !size.equals(ref.getSize())) {
                throw new IllegalArgumentException("Cannot use existing queue " + key + " as the existing queue size " + (ref.getSize() != null ? ref.getSize() : 1000) + " does not match given queue size " + size);
            }
            ref.addReference(endpoint);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reusing existing queue {} with size {} and reference count {}", new Object[]{key, size, ref.getCount()});
            }
            return ref;
        }
        BlockingQueueFactory<Exchange> blockingQueueFactory = queueFactory = customQueueFactory == null ? this.defaultQueueFactory : customQueueFactory;
        if (size != null && size > 0) {
            queue = queueFactory.create(size);
        } else if (this.getQueueSize() > 0) {
            size = this.getQueueSize();
            queue = queueFactory.create(this.getQueueSize());
        } else {
            queue = queueFactory.create();
        }
        this.log.debug("Created queue {} with size {}", (Object)key, (Object)size);
        ref = new QueueReference(queue, size, multipleConsumers);
        ref.addReference(endpoint);
        this.getQueues().put(key, ref);
        return ref;
    }

    public synchronized QueueReference registerQueue(SedaEndpoint endpoint, BlockingQueue<Exchange> queue) {
        String key = this.getQueueKey(endpoint.getEndpointUri());
        QueueReference ref = this.getQueues().get(key);
        if (ref == null) {
            ref = new QueueReference(queue, endpoint.getSize(), endpoint.isMultipleConsumers());
            ref.addReference(endpoint);
            this.getQueues().put(key, ref);
        }
        return ref;
    }

    public Map<String, QueueReference> getQueues() {
        return this.queues;
    }

    public QueueReference getQueueReference(String key) {
        return this.queues.get(key);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SedaEndpoint answer;
        int consumers = this.getAndRemoveOrResolveReferenceParameter(parameters, "concurrentConsumers", Integer.class, this.concurrentConsumers);
        boolean limitConcurrentConsumers = this.getAndRemoveOrResolveReferenceParameter(parameters, "limitConcurrentConsumers", Boolean.class, true);
        if (limitConcurrentConsumers && consumers > 500) {
            throw new IllegalArgumentException("The limitConcurrentConsumers flag in set to true. ConcurrentConsumers cannot be set at a value greater than 500 was " + consumers);
        }
        BlockingQueue queue = this.resolveAndRemoveReferenceParameter(parameters, "queue", BlockingQueue.class);
        if (queue == null) {
            BlockingQueueFactory queueFactory = this.resolveAndRemoveReferenceParameter(parameters, "queueFactory", BlockingQueueFactory.class);
            answer = this.createEndpoint(uri, (Component)this, queueFactory, consumers);
        } else {
            answer = this.createEndpoint(uri, (Component)this, queue, consumers);
        }
        boolean blockWhenFull = this.getAndRemoveParameter(parameters, "blockWhenFull", Boolean.TYPE, this.defaultBlockWhenFull);
        long offerTimeout = this.getAndRemoveParameter(parameters, "offerTimeout", Long.TYPE, this.defaultOfferTimeout);
        answer.setOfferTimeout(offerTimeout);
        answer.setBlockWhenFull(blockWhenFull);
        answer.configureProperties(parameters);
        answer.setConcurrentConsumers(consumers);
        answer.setLimitConcurrentConsumers(limitConcurrentConsumers);
        return answer;
    }

    protected SedaEndpoint createEndpoint(String endpointUri, Component component, BlockingQueueFactory<Exchange> queueFactory, int concurrentConsumers) {
        return new SedaEndpoint(endpointUri, component, queueFactory, concurrentConsumers);
    }

    protected SedaEndpoint createEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        return new SedaEndpoint(endpointUri, component, queue, concurrentConsumers);
    }

    public String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    @Override
    protected void doStop() throws Exception {
        this.getQueues().clear();
        super.doStop();
    }

    void onShutdownEndpoint(SedaEndpoint endpoint) {
        String key = this.getQueueKey(endpoint.getEndpointUri());
        QueueReference ref = this.getQueues().get(key);
        if (ref != null && endpoint.getConsumers().size() == 0) {
            ref.removeReference(endpoint);
            if (ref.getCount() <= 0) {
                this.getQueues().remove(key);
            }
        }
    }
}

