/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data.statistics;

import java.io.Serializable;

public class NormalDistributionStatistics
implements Serializable {
    private static final long serialVersionUID = -5422805289301484436L;
    private final double min;
    private final double max;
    private final double sumOfSquares;
    private final double sumOfValues;
    private final long n;

    public NormalDistributionStatistics(double min, double max, double sumOfSquares, double sumOfValues, long n) {
        this.min = min;
        this.max = max;
        this.sumOfSquares = sumOfSquares;
        this.sumOfValues = sumOfValues;
        this.n = n;
    }

    public NormalDistributionStatistics plus(NormalDistributionStatistics stats) {
        return new NormalDistributionStatistics(Math.min(this.min, stats.min), Math.max(this.max, stats.max), this.sumOfSquares + stats.sumOfSquares, this.sumOfValues + stats.sumOfValues, this.n + stats.n);
    }

    public double mean() {
        return this.sumOfValues / (double)this.n;
    }

    public double variance() {
        double mean = this.mean();
        return this.sumOfSquares / (double)this.n - mean * mean;
    }

    public double std() {
        return Math.sqrt(this.variance());
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }
}

