/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;
import org.apache.ignite.ml.selection.scoring.metric.classification.Precision;
import org.apache.ignite.ml.selection.scoring.metric.classification.Recall;

public class FMeasure<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = 9156779288165194348L;
    private final double betaSquare;
    private final Precision<L> precision = new Precision();
    private final Recall<L> recall = new Recall();
    private Double fscore = Double.NaN;

    public FMeasure(double beta) {
        this.betaSquare = Math.pow(beta, 2.0);
    }

    public FMeasure() {
        this.betaSquare = 1.0;
    }

    public FMeasure(L truthLabel, L falseLabel, double betaSquare) {
        super(truthLabel, falseLabel);
        this.betaSquare = betaSquare;
    }

    public FMeasure(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
        this.betaSquare = 1.0;
    }

    public FMeasure<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        this.precision.initBy(aggr);
        this.recall.initBy(aggr);
        double nom = (1.0 + this.betaSquare) * this.precision.value() * this.recall.value();
        double denom = this.betaSquare * this.precision.value() + this.recall.value();
        this.fscore = nom / denom;
        return this;
    }

    @Override
    public double value() {
        return this.fscore;
    }

    @Override
    public MetricName name() {
        return MetricName.F_MEASURE;
    }
}

