/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.evaluator.aggregator;

import java.io.Serializable;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.MetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.evaluator.context.EmptyContext;
import org.apache.ignite.ml.selection.scoring.evaluator.context.EvaluationContext;
import org.apache.ignite.ml.structures.LabeledVector;

public class ClassificationMetricsAggregator<L extends Serializable>
implements MetricStatsAggregator<L, EmptyContext<L>, ClassificationMetricsAggregator<L>> {
    private static final long serialVersionUID = 6508258921730584458L;
    private long validAnswersCnt;
    private long totalNumOfExamples;

    public ClassificationMetricsAggregator() {
    }

    public ClassificationMetricsAggregator(long validAnswersCnt, long totalNumOfExamples) {
        this.validAnswersCnt = validAnswersCnt;
        this.totalNumOfExamples = totalNumOfExamples;
    }

    @Override
    public void aggregate(IgniteModel<Vector, L> mdl, LabeledVector<L> vector) {
        Serializable truth;
        Serializable modelAns = (Serializable)mdl.predict(vector.features());
        if (modelAns.equals(truth = (Serializable)vector.label())) {
            ++this.validAnswersCnt;
        }
        ++this.totalNumOfExamples;
    }

    @Override
    public ClassificationMetricsAggregator<L> mergeWith(ClassificationMetricsAggregator<L> other) {
        return new ClassificationMetricsAggregator<L>(this.validAnswersCnt + other.validAnswersCnt, this.totalNumOfExamples + other.totalNumOfExamples);
    }

    @Override
    public EmptyContext<L> createInitializedContext() {
        return EvaluationContext.empty();
    }

    @Override
    public void initByContext(EmptyContext<L> ctx) {
    }

    public long getValidAnswersCount() {
        return this.validAnswersCnt;
    }

    public long getTotalNumberOfExamples() {
        return this.totalNumOfExamples;
    }
}

