/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.stat;

import java.util.Collections;
import java.util.List;
import java.util.stream.DoubleStream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.math.stat.Distribution;

public abstract class DistributionMixture<C extends Distribution>
implements Distribution {
    private final Vector componentProbs;
    private final List<C> distributions;
    private final int dimension;

    public DistributionMixture(Vector componentProbs, List<C> distributions) {
        A.ensure((boolean)DoubleStream.of(componentProbs.asArray()).allMatch(v -> v > 0.0), (String)"All distribution components should be greater than zero");
        componentProbs = componentProbs.divide(componentProbs.sum());
        A.ensure((!distributions.isEmpty() ? 1 : 0) != 0, (String)"Distribution mixture should have at least one component");
        int dimension = ((Distribution)distributions.get(0)).dimension();
        A.ensure((dimension > 0 ? 1 : 0) != 0, (String)"Dimension should be greater than zero");
        A.ensure((boolean)distributions.stream().allMatch(d -> d.dimension() == dimension), (String)"All distributions should have same dimension");
        this.distributions = distributions;
        this.componentProbs = componentProbs;
        this.dimension = dimension;
    }

    @Override
    public double prob(Vector x) {
        return this.likelihood(x).sum();
    }

    public Vector likelihood(Vector x) {
        return VectorUtils.of(this.distributions.stream().mapToDouble(f -> f.prob(x)).toArray()).times(this.componentProbs);
    }

    public int countOfComponents() {
        return this.componentProbs.size();
    }

    public Vector componentsProbs() {
        return this.componentProbs.copy();
    }

    public List<C> distributions() {
        return Collections.unmodifiableList(this.distributions);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }
}

