/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.kafka.connect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.events.EventType;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.stream.kafka.connect.IgniteSinkConnector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteSourceTask
extends SourceTask {
    private static final Logger log = LoggerFactory.getLogger(IgniteSourceTask.class);
    private static final Object lock = new Object();
    private static int evtBufSize = 100000;
    private static BlockingQueue<CacheEvent> evtBuf = new LinkedBlockingQueue<CacheEvent>(evtBufSize);
    private static int evtBatchSize = 100;
    private static volatile boolean stopped = true;
    private static String igniteCfgFile;
    private static String cacheName;
    private static UUID rmtLsnrId;
    private static TaskLocalListener locLsnr;
    private static IgnitePredicate<CacheEvent> filter;
    private static String[] topics;
    private static final Map<String, Long> offset;
    private static final Map<String, String> srcPartition;

    public String version() {
        return new IgniteSinkConnector().version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, String> props) {
        Object object = lock;
        synchronized (object) {
            String filterCls;
            if (!stopped) {
                return;
            }
            cacheName = props.get("cacheName");
            igniteCfgFile = props.get("igniteCfg");
            topics = props.get("topicNames").split("\\s*,\\s*");
            if (props.containsKey("evtBufferSize")) {
                evtBufSize = Integer.parseInt(props.get("evtBufferSize"));
            }
            if (props.containsKey("evtBatchSize")) {
                evtBatchSize = Integer.parseInt(props.get("evtBatchSize"));
            }
            if (props.containsKey("cacheFilterCls") && (filterCls = props.get("cacheFilterCls")) != null && !filterCls.isEmpty()) {
                try {
                    Class<?> clazz = Class.forName(filterCls);
                    filter = (IgnitePredicate)clazz.newInstance();
                }
                catch (Exception e) {
                    log.error("Failed to instantiate the provided filter! User-enabled filtering is ignored!", (Throwable)e);
                }
            }
            TaskRemoteFilter rmtLsnr = new TaskRemoteFilter(cacheName);
            try {
                int[] evts = this.cacheEvents(props.get("cacheEvts"));
                rmtLsnrId = IgniteGrid.getIgnite().events(IgniteGrid.getIgnite().cluster().forCacheNodes(cacheName)).remoteListen((IgniteBiPredicate)locLsnr, (IgnitePredicate)rmtLsnr, evts);
            }
            catch (Exception e) {
                log.error("Failed to register event listener!", (Throwable)e);
                throw new ConnectException((Throwable)e);
            }
            finally {
                stopped = false;
            }
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        ArrayList<SourceRecord> records = new ArrayList<SourceRecord>(evtBatchSize);
        ArrayList evts = new ArrayList(evtBatchSize);
        if (stopped) {
            return records;
        }
        try {
            if (evtBuf.drainTo(evts, evtBatchSize) > 0) {
                for (CacheEvent evt : evts) {
                    for (String topic : topics) {
                        records.add(new SourceRecord(srcPartition, offset, topic, null, (Object)evt));
                    }
                }
                return records;
            }
        }
        catch (IgniteException e) {
            log.error("Error when polling event queue!", (Throwable)e);
        }
        return null;
    }

    private int[] cacheEvents(String evtPropsStr) throws Exception {
        String[] evtStr = evtPropsStr.split("\\s*,\\s*");
        if (evtStr.length == 0) {
            return EventType.EVTS_CACHE;
        }
        int[] evts = new int[evtStr.length];
        try {
            for (int i = 0; i < evtStr.length; ++i) {
                evts[i] = CacheEvt.valueOf(evtStr[i].toUpperCase()).getId();
            }
        }
        catch (Exception e) {
            log.error("Failed to recognize the provided cache event!", (Throwable)e);
            throw new Exception(e);
        }
        return evts;
    }

    public synchronized void stop() {
        if (stopped) {
            return;
        }
        stopped = true;
        this.stopRemoteListen();
        IgniteGrid.getIgnite().close();
    }

    protected void stopRemoteListen() {
        if (rmtLsnrId != null) {
            IgniteGrid.getIgnite().events(IgniteGrid.getIgnite().cluster().forCacheNodes(cacheName)).stopRemoteListen(rmtLsnrId);
        }
        rmtLsnrId = null;
    }

    protected static void setStopped(boolean stopped) {
        IgniteSourceTask.stopped = stopped;
    }

    static /* synthetic */ String access$500() {
        return igniteCfgFile;
    }

    static {
        locLsnr = new TaskLocalListener();
        offset = Collections.singletonMap("offset", 0L);
        srcPartition = Collections.singletonMap("cache", null);
    }

    private static enum CacheEvt {
        CREATED(60),
        DESTROYED(61),
        PUT(63),
        READ(64),
        REMOVED(65),
        LOCKED(66),
        UNLOCKED(67),
        EXPIRED(70);

        private final int id;

        private CacheEvt(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }
    }

    private static class IgniteGrid {
        private IgniteGrid() {
        }

        private static Ignite getIgnite() {
            return Holder.IGNITE;
        }

        private static class Holder {
            private static final Ignite IGNITE = Ignition.start((String)IgniteSourceTask.access$500());

            private Holder() {
            }
        }
    }

    private static class TaskRemoteFilter
    implements IgnitePredicate<CacheEvent> {
        @IgniteInstanceResource
        Ignite ignite;
        private final String cacheName;

        TaskRemoteFilter(String cacheName) {
            this.cacheName = cacheName;
        }

        public boolean apply(CacheEvent evt) {
            Affinity affinity = this.ignite.affinity(this.cacheName);
            if (affinity.isPrimary(this.ignite.cluster().localNode(), evt.key())) {
                return filter == null || !filter.apply((Object)evt);
            }
            return false;
        }
    }

    private static class TaskLocalListener
    implements IgniteBiPredicate<UUID, CacheEvent> {
        private TaskLocalListener() {
        }

        public boolean apply(UUID id, CacheEvent evt) {
            try {
                if (!evtBuf.offer(evt, 10L, TimeUnit.MILLISECONDS)) {
                    log.error("Failed to buffer event {}", (Object)evt.name());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

