/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.kafka.connect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.kafka.connect.IgniteSourceTask;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;

public class IgniteSourceConnector
extends SourceConnector {
    private Map<String, String> configProps;
    private static final ConfigDef CONFIG_DEF = new ConfigDef();

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        try {
            A.notNullOrEmpty((String)props.get("cacheName"), (String)"cache name");
            A.notNullOrEmpty((String)props.get("igniteCfg"), (String)"path to cache config file");
            A.notNullOrEmpty((String)props.get("cacheEvts"), (String)"Registered cache events");
            A.notNullOrEmpty((String)props.get("topicNames"), (String)"Kafka topics");
        }
        catch (IllegalArgumentException e) {
            throw new ConnectException("Cannot start IgniteSourceConnector due to configuration error", (Throwable)e);
        }
        this.configProps = props;
    }

    public Class<? extends Task> taskClass() {
        return IgniteSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        HashMap<String, String> taskProps = new HashMap<String, String>();
        taskProps.putAll(this.configProps);
        for (int i = 0; i < maxTasks; ++i) {
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

